/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;

public class BlockingCallback
implements Callback {
    private static Throwable COMPLETED = new Throwable();
    private final AtomicBoolean _done = new AtomicBoolean(false);
    private final Semaphore _semaphore = new Semaphore(0);
    private Throwable _cause;

    @Override
    public void succeeded() {
        if (this._done.compareAndSet(false, true)) {
            this._cause = COMPLETED;
            this._semaphore.release();
        }
    }

    @Override
    public void failed(Throwable cause) {
        if (this._done.compareAndSet(false, true)) {
            this._cause = cause;
            this._semaphore.release();
        }
    }

    public void block() throws IOException {
        try {
            this._semaphore.acquire();
            if (this._cause == COMPLETED) {
                return;
            }
            try {
                if (this._cause instanceof IOException) {
                    throw (IOException)this._cause;
                }
                if (this._cause instanceof CancellationException) {
                    throw (CancellationException)this._cause;
                }
                throw new IOException(this._cause);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(){
                    {
                        this.initCause(e);
                    }
                };
            }
        }
        finally {
            this._done.set(false);
            this._cause = null;
        }
    }

    public String toString() {
        return String.format("%s@%x{%b,%b}", BlockingCallback.class.getSimpleName(), this.hashCode(), this._done.get(), this._cause == COMPLETED);
    }
}

