/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.cdi.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.cdi.api.model.BeansXmlDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jcp.xmlns.xml.ns.javaee.Alternatives;
import org.jcp.xmlns.xml.ns.javaee.Beans;
import org.jcp.xmlns.xml.ns.javaee.Decorators;
import org.jcp.xmlns.xml.ns.javaee.Interceptors;
import org.jcp.xmlns.xml.ns.javaee.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeansXmlScannerPlugin
extends AbstractScannerPlugin<FileResource, BeansXmlDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeansXmlScannerPlugin.class);
    private static final JAXBContext jaxbContext;

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return JavaScope.CLASSPATH.equals((Object)scope) && "/META-INF/beans.xml".equals(path) || "/WEB-INF/beans.xml".equals(path);
    }

    public BeansXmlDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        BeansXmlDescriptor beansXmlDescriptor = (BeansXmlDescriptor)context.getStore().addDescriptorType((Descriptor)xmlFileDescriptor, BeansXmlDescriptor.class);
        try (InputStream stream = item.createStream();){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Beans beans = (Beans)unmarshaller.unmarshal((Source)new StreamSource(stream), Beans.class).getValue();
            beansXmlDescriptor.setVersion(beans.getVersion());
            beansXmlDescriptor.setBeanDiscoveryMode(beans.getBeanDiscoveryMode());
            for (Object o : beans.getInterceptorsOrDecoratorsOrAlternatives()) {
                if (o instanceof Interceptors) {
                    this.addTypes(((Interceptors)o).getClazz(), beansXmlDescriptor.getInterceptors(), context);
                    continue;
                }
                if (o instanceof Decorators) {
                    this.addTypes(((Decorators)o).getClazz(), beansXmlDescriptor.getDecorators(), context);
                    continue;
                }
                if (!(o instanceof Alternatives)) continue;
                List<JAXBElement<String>> clazzOrStereotype = ((Alternatives)o).getClazzOrStereotype();
                for (JAXBElement<String> element : clazzOrStereotype) {
                    TypeDescriptor alternative = ((TypeResolver)scanner.getContext().peek(TypeResolver.class)).resolve((String)element.getValue(), context).getTypeDescriptor();
                    beansXmlDescriptor.getAlternatives().add(alternative);
                }
            }
        }
        catch (JAXBException e) {
            LOGGER.warn("Cannot read CDI beans descriptor '{}'.", (Object)path, (Object)e);
        }
        return beansXmlDescriptor;
    }

    private void addTypes(List<String> typeNames, List<TypeDescriptor> types, ScannerContext scannerContext) {
        for (String typeName : typeNames) {
            TypeDescriptor type = ((TypeResolver)scannerContext.peek(TypeResolver.class)).resolve(typeName, scannerContext).getTypeDescriptor();
            types.add(type);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }
}

