/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl.rest;

import com.buschmais.jqassistant.core.analysis.api.rule.Metric;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AbstractJQARestService;
import com.buschmais.xo.api.Query;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/metrics")
public class MetricsService
extends AbstractJQARestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsService.class);
    private static final String PARAMETER_GROUP_METRIC_ID = "groupMetricId";
    private static final String PARAMETER_METRIC_ID = "metricId";
    private static final String JSON_OBJECT_KEY_RESULT = "result";
    private static final String JSON_OBJECT_KEY_ERRORS = "error";
    private static final String JSON_OBJECT_KEY_COLUMNS = "columns";
    private static final String JSON_OBJECT_KEY_ROW = "row";
    private static final String JSON_OBJECT_KEY_DATA = "data";
    private static final String JSON_OBJECT_KEY_ID = "id";
    private static final String JSON_OBJECT_KEY_DESCRIPTION = "description";
    private static final String JSON_OBJECT_KEY_CYPHER = "cypher";
    private static final String JSON_OBJECT_KEY_PARAMETERS = "parameters";
    private static final String JSON_OBJECT_KEY_METRICS = "metrics";

    public MetricsService(@Context Store store) throws PluginRepositoryException {
        super(store);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/")
    public JSONArray getMetrics() {
        JSONArray metrics = new JSONArray();
        try {
            for (MetricGroup metricGroup : this.readMetricGroups().values()) {
                metrics.put((Object)this.metricGroupAsJsonObject(metricGroup));
            }
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return metrics;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/run")
    public Response executeMetric(@Context UriInfo uriInfo) {
        String metricId;
        MultivaluedMap uriParameters = uriInfo.getQueryParameters();
        String groupId = (String)uriParameters.getFirst((Object)PARAMETER_GROUP_METRIC_ID);
        Metric metric = this.findMetric(groupId, metricId = (String)uriParameters.getFirst((Object)PARAMETER_METRIC_ID));
        if (metric != null) {
            ArrayList<String> conceptIds = new ArrayList<String>();
            for (Object conceptId : metric.getRequiresConcepts()) {
                conceptIds.add((String)conceptId);
            }
            if (!conceptIds.isEmpty()) {
                try {
                    this.analyze(conceptIds, Collections.emptyList(), Collections.emptyList());
                }
                catch (Exception e) {
                    LOGGER.error("Executing concepts (" + conceptIds + ") for metric (" + groupId + "/" + metricId + ") failed.", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            for (String queryParameter : metric.getParameterTypes().keySet()) {
                queryParameters.put(queryParameter, uriParameters.getFirst((Object)queryParameter));
            }
            Store store = this.getStore();
            Query.Result queryResult = store.executeQuery(metric.getCypher(), queryParameters);
            try {
                JSONObject jResponse = this.createJsonResponse((Query.Result<Query.Result.CompositeRowObject>)queryResult);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)jResponse.toString()).build();
            }
            catch (JSONException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        try {
            String message = MessageFormat.format("Unable to find metric for group id '{0}' and metric id '{1}'.", groupId, metricId);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.createJsonError(message).toString()).build();
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Metric findMetric(String metricGroupId, String metricId) {
        MetricGroup metricGroup = this.readMetricGroups().get(metricGroupId);
        if (metricGroup != null) {
            return (Metric)metricGroup.getMetrics().get(metricId);
        }
        return null;
    }

    private JSONObject createJsonError(String errorMessage) throws JSONException {
        JSONObject jResponse = new JSONObject();
        jResponse.put(JSON_OBJECT_KEY_ERRORS, (Object)errorMessage);
        return jResponse;
    }

    private JSONObject createJsonResponse(Query.Result<Query.Result.CompositeRowObject> queryResult) throws JSONException {
        if (queryResult == null || !queryResult.hasResult()) {
            return this.createJsonError("Executing the metric returned empty result.");
        }
        JSONObject response = new JSONObject();
        JSONObject result = new JSONObject();
        response.put(JSON_OBJECT_KEY_RESULT, (Object)result);
        JSONArray columns = new JSONArray();
        result.put(JSON_OBJECT_KEY_COLUMNS, (Object)columns);
        boolean columnsSet = false;
        JSONArray data = new JSONArray();
        result.put(JSON_OBJECT_KEY_DATA, (Object)data);
        for (Query.Result.CompositeRowObject queryRow : queryResult) {
            JSONObject dataObject = new JSONObject();
            JSONArray row = new JSONArray();
            dataObject.put(JSON_OBJECT_KEY_ROW, (Object)row);
            List queryColumns = queryRow.getColumns();
            for (String column : queryColumns) {
                if (!columnsSet) {
                    columns.put((Object)column);
                }
                row.put(queryRow.get(column, Object.class));
            }
            columnsSet = true;
            data.put((Object)dataObject);
        }
        return response;
    }

    private JSONObject metricGroupAsJsonObject(MetricGroup metricGroup) throws JSONException {
        JSONObject object = new JSONObject();
        object.put(JSON_OBJECT_KEY_ID, (Object)metricGroup.getId());
        object.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)metricGroup.getDescription());
        JSONArray metricsArray = new JSONArray();
        for (Metric metric : metricGroup.getMetrics().values()) {
            JSONObject metricObject = new JSONObject();
            metricObject.put(JSON_OBJECT_KEY_ID, (Object)metric.getId());
            metricObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)metric.getDescription());
            metricObject.put(JSON_OBJECT_KEY_CYPHER, (Object)metric.getCypher());
            JSONArray parameterArray = new JSONArray();
            for (String parameterKey : metric.getParameterTypes().keySet()) {
                parameterArray.put((Object)parameterKey);
            }
            metricObject.put(JSON_OBJECT_KEY_PARAMETERS, (Object)parameterArray);
            metricsArray.put((Object)metricObject);
        }
        object.put(JSON_OBJECT_KEY_METRICS, (Object)metricsArray);
        return object;
    }

    private Map<String, MetricGroup> readMetricGroups() {
        return this.getAvailableRules().getMetricGroups();
    }
}

