/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl.rest;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AbstractJQARestService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/analysis")
public class AnalysisService
extends AbstractJQARestService {
    private static final String JSON_OBJECT_KEY_CONCEPTS = "concepts";
    private static final String JSON_OBJECT_KEY_ID = "id";
    private static final String JSON_OBJECT_KEY_DESCRIPTION = "description";
    private static final String JSON_OBJECT_KEY_CYPHER = "cypher";
    private static final String JSON_OBJECT_KEY_CONSTRAINTS = "constraints";
    private static final String JSON_OBJECT_KEY_GROUPS = "groups";

    public AnalysisService(@Context Store store) throws PluginRepositoryException {
        super(store);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/rules")
    public Response getRuleSet() {
        try {
            JSONObject jsonResponse = this.createJsonResponse(this.getAvailableRules());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResponse.toString()).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    public String getSomething() {
        return "something";
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/concept")
    public Response runConcept(String conceptId) {
        try {
            InMemoryReportWriter report = this.analyze(Arrays.asList(conceptId), Collections.emptyList(), Collections.emptyList());
            Result conceptResult = (Result)report.getConceptResults().get(conceptId);
            if (conceptResult == null) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            int effectedRows = conceptResult.getRows().size();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/constraint")
    public Response runConstraint(String constraintId) {
        try {
            InMemoryReportWriter report = this.analyze(Collections.emptyList(), Arrays.asList(constraintId), Collections.emptyList());
            int effectedRows = ((Result)report.getConstraintViolations().get(constraintId)).getRows().size();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="/group")
    public Response runGroup(String groupId) {
        try {
            InMemoryReportWriter report = this.analyze(Collections.emptyList(), Collections.emptyList(), Arrays.asList(groupId));
            int effectedRows = 0;
            for (Result conceptResult : report.getConceptResults().values()) {
                effectedRows += conceptResult.getRows().size();
            }
            for (Result constraintResult : report.getConstraintViolations().values()) {
                effectedRows += constraintResult.getRows().size();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Integer.toString(effectedRows)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private JSONObject createJsonResponse(RuleSet ruleSet) throws JSONException {
        JSONObject response = new JSONObject();
        JSONArray concepts = new JSONArray();
        response.put(JSON_OBJECT_KEY_CONCEPTS, (Object)concepts);
        for (Map.Entry entry : ruleSet.getConcepts().entrySet()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_OBJECT_KEY_ID, (Object)((Concept)entry.getValue()).getId());
            jSONObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)((Concept)entry.getValue()).getDescription());
            jSONObject.put(JSON_OBJECT_KEY_CYPHER, (Object)((Concept)entry.getValue()).getCypher());
            concepts.put((Object)jSONObject);
        }
        JSONArray constraints = new JSONArray();
        response.put(JSON_OBJECT_KEY_CONSTRAINTS, (Object)constraints);
        for (Map.Entry entry : ruleSet.getConstraints().entrySet()) {
            JSONObject constraintObject = new JSONObject();
            constraintObject.put(JSON_OBJECT_KEY_ID, (Object)((Constraint)entry.getValue()).getId());
            constraintObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)((Constraint)entry.getValue()).getDescription());
            constraintObject.put(JSON_OBJECT_KEY_CYPHER, (Object)((Constraint)entry.getValue()).getCypher());
            constraints.put((Object)constraintObject);
        }
        JSONArray jSONArray = new JSONArray();
        response.put(JSON_OBJECT_KEY_GROUPS, (Object)jSONArray);
        for (Map.Entry group : ruleSet.getGroups().entrySet()) {
            JSONObject groupObject = new JSONObject();
            groupObject.put(JSON_OBJECT_KEY_ID, (Object)((Group)group.getValue()).getId());
            groupObject.put(JSON_OBJECT_KEY_DESCRIPTION, (Object)((Group)group.getValue()).getDescription());
            jSONArray.put((Object)groupObject);
        }
        return response;
    }
}

