/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl;

import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.neo4jserver.api.Server;
import com.buschmais.jqassistant.scm.neo4jserver.impl.JQAServerModule;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.AnalysisService;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.MetricsService;
import com.buschmais.jqassistant.scm.neo4jserver.impl.rest.VersionService;
import com.sun.jersey.api.core.HttpContext;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.WrappingNeoServer;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.modules.ServerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
extends WrappingNeoServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServer.class);
    protected final Store store;

    public AbstractServer(EmbeddedGraphStore graphStore) {
        super((GraphDatabaseAPI)graphStore.getGraphDatabaseService());
        this.store = graphStore;
    }

    protected Iterable<ServerModule> createServerModules() {
        ArrayList<String> extensionNames = new ArrayList<String>();
        extensionNames.add(VersionService.class.getName());
        extensionNames.add(AnalysisService.class.getName());
        extensionNames.add(MetricsService.class.getName());
        for (Class<?> extension : this.getExtensions()) {
            extensionNames.add(extension.getName());
        }
        if (LOGGER.isInfoEnabled()) {
            for (String extensionName : extensionNames) {
                LOGGER.info("Registering extension: " + extensionName);
            }
        }
        ArrayList<ServerModule> serverModules = new ArrayList<ServerModule>();
        serverModules.add(new JQAServerModule(this.webServer, extensionNames));
        for (ServerModule serverModule : super.createServerModules()) {
            serverModules.add(serverModule);
        }
        return serverModules;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        Collection defaultInjectables = super.createDefaultInjectables();
        this.addInjectable(Store.class, this.store, defaultInjectables);
        this.addInjectable(RulePluginRepository.class, this.getRulePluginRepository(), defaultInjectables);
        this.addInjectable(ScannerPluginRepository.class, this.getScannerPluginRepository(), defaultInjectables);
        return defaultInjectables;
    }

    private <T> void addInjectable(Class<T> type, final T injectable, Collection<InjectableProvider<?>> defaultInjectables) {
        defaultInjectables.add(new InjectableProvider<T>(type){

            public T getValue(HttpContext c) {
                return injectable;
            }
        });
    }

    protected abstract Iterable<? extends Class<?>> getExtensions();

    protected abstract ScannerPluginRepository getScannerPluginRepository();

    protected abstract RulePluginRepository getRulePluginRepository();
}

