/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.cli.task.AbstractJQATask;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public class ScanTask
extends AbstractJQATask {
    public static final String CMDLINE_OPTION_FILES = "f";
    public static final String CMDLINE_OPTION_URLS = "u";
    public static final String CMDLINE_OPTION_RESET = "reset";
    private Map<String, String> files = Collections.emptyMap();
    private Map<String, String> urls = Collections.emptyMap();
    private boolean reset = false;

    @Override
    protected void addTaskOptions(List<Option> options) {
        OptionBuilder.withArgName((String)CMDLINE_OPTION_FILES);
        OptionBuilder.withLongOpt((String)"files");
        OptionBuilder.withDescription((String)"The files or directories to be scanned, comma separated, each with optional scope prefix.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_FILES));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_URLS);
        OptionBuilder.withLongOpt((String)"urls");
        OptionBuilder.withDescription((String)"The URLs to be scanned, comma separated, each with optional scope prefix.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_URLS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_RESET);
        OptionBuilder.withDescription((String)"Reset store before scanning (default=false).");
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_RESET));
    }

    @Override
    protected void executeTask(Store store) throws CliExecutionException {
        String scopeName;
        List scannerPlugins;
        try {
            scannerPlugins = this.scannerPluginRepository.getScannerPlugins();
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get scanner plugins.", e);
        }
        if (this.reset) {
            store.reset();
        }
        for (Map.Entry<String, String> entry : this.files.entrySet()) {
            String fileName = entry.getKey();
            scopeName = entry.getValue();
            File file = new File(fileName);
            String absolutePath = file.getAbsolutePath();
            if (!file.exists()) {
                Log.getLog().info(absolutePath + "' does not exist, skipping scan.");
                continue;
            }
            this.scan(store, file, file.getAbsolutePath(), scopeName, scannerPlugins);
        }
        for (Map.Entry<String, String> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            scopeName = entry.getValue();
            try {
                this.scan(store, new URL(url), url, scopeName, scannerPlugins);
            }
            catch (MalformedURLException e) {
                throw new CliConfigurationException("Cannot parse URL " + url, e);
            }
        }
    }

    private Map<String, String> parseResources(List<String> optionValues) {
        HashMap<String, String> resources = new HashMap<String, String>();
        for (String file : optionValues) {
            String[] parts = file.split("::");
            String fileName = null;
            String scopeName = null;
            if (parts.length == 2) {
                scopeName = parts[0];
                fileName = parts[1];
            } else {
                fileName = parts[0];
            }
            resources.put(fileName, scopeName);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scan(Store store, T element, String path, String scopeName, List<ScannerPlugin<?, ?>> scannerPlugins) {
        store.beginTransaction();
        ScannerImpl scanner = new ScannerImpl(store, scannerPlugins, this.scopePluginRepository.getScopes());
        Scope scope = scanner.resolveScope(scopeName);
        try {
            scanner.scan(element, path, scope);
        }
        finally {
            store.commitTransaction();
        }
    }

    @Override
    public void withOptions(CommandLine options) throws CliConfigurationException {
        this.files = this.parseResources(this.getOptionValues(options, CMDLINE_OPTION_FILES, Collections.emptyList()));
        this.urls = this.parseResources(this.getOptionValues(options, CMDLINE_OPTION_URLS, Collections.emptyList()));
        if (this.files.isEmpty() && this.urls.isEmpty()) {
            throw new CliConfigurationException("No files, directories or urls given.");
        }
        this.reset = options.hasOption(CMDLINE_OPTION_RESET);
    }
}

