/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.plugin.api.ModelPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ReportPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.ScopePluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.ModelPluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ReportPluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ScannerPluginRepositoryImpl;
import com.buschmais.jqassistant.core.plugin.impl.ScopePluginRepositoryImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.JQATask;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.common.report.ReportHelper;
import com.buschmais.jqassistant.scm.common.report.RuleHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public abstract class AbstractJQATask
implements JQATask {
    protected static final String CMDLINE_OPTION_S = "s";
    protected static final String CMDLINE_OPTION_REPORTDIR = "reportDirectory";
    private static final Console LOG = Log.getLog();
    protected Map<String, Object> properties;
    protected String storeDirectory;
    protected RuleHelper ruleHelper;
    protected ReportHelper reportHelper;
    protected ClassLoader classLoader;
    protected ModelPluginRepository modelPluginRepository;
    protected ScannerPluginRepository scannerPluginRepository;
    protected ScopePluginRepository scopePluginRepository;
    protected RulePluginRepository rulePluginRepository;
    protected ReportPluginRepository reportPluginRepository;

    @Override
    public void initialize(PluginConfigurationReader pluginConfigurationReader, Map<String, Object> properties) throws CliExecutionException {
        this.properties = properties;
        try {
            this.classLoader = pluginConfigurationReader.getClassLoader();
            this.modelPluginRepository = new ModelPluginRepositoryImpl(pluginConfigurationReader);
            this.scannerPluginRepository = new ScannerPluginRepositoryImpl(pluginConfigurationReader, properties);
            this.scopePluginRepository = new ScopePluginRepositoryImpl(pluginConfigurationReader);
            this.rulePluginRepository = new RulePluginRepositoryImpl(pluginConfigurationReader);
            this.reportPluginRepository = new ReportPluginRepositoryImpl(pluginConfigurationReader, properties);
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot create plugin repositories.", e);
        }
        this.ruleHelper = new RuleHelper((Console)Log.getLog());
        this.reportHelper = new ReportHelper((Console)Log.getLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws CliExecutionException {
        List descriptorTypes;
        Store store = this.getStore();
        try {
            descriptorTypes = this.modelPluginRepository.getDescriptorTypes();
        }
        catch (PluginRepositoryException e) {
            throw new RuntimeException("Cannot get model.", e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            store.start((Collection)descriptorTypes);
            this.executeTask(store);
        }
        finally {
            store.stop();
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void withStandardOptions(CommandLine options) {
        this.storeDirectory = this.getOptionValue(options, CMDLINE_OPTION_S, "jqassistant/store");
    }

    @Override
    public List<Option> getOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        OptionBuilder.withArgName((String)CMDLINE_OPTION_S);
        OptionBuilder.withLongOpt((String)"storeDirectory");
        OptionBuilder.withDescription((String)"The location of the Neo4j database.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_S));
        this.addTaskOptions(options);
        return options;
    }

    protected List<String> getOptionValues(CommandLine options, String option, List<String> defaultValues) {
        if (options.hasOption(option)) {
            ArrayList<String> names = new ArrayList<String>();
            for (String elementName : options.getOptionValues(option)) {
                if (elementName.trim().length() <= 0) continue;
                names.add(elementName);
            }
            return names;
        }
        return defaultValues;
    }

    protected String getOptionValue(CommandLine options, String option, String defaultValue) {
        if (options.hasOption(option)) {
            return options.getOptionValue(option);
        }
        return defaultValue;
    }

    protected void addTaskOptions(List<Option> options) {
    }

    protected Store getStore() {
        File directory = new File(this.storeDirectory);
        LOG.info("Opening store in directory '" + directory.getAbsolutePath() + "'");
        directory.getParentFile().mkdirs();
        return new EmbeddedGraphStore(directory.getAbsolutePath());
    }

    protected abstract void executeTask(Store var1) throws CliExecutionException;
}

