/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.analysis.api.CompoundRuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.source.FileRuleSource;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.cli.task.AbstractJQATask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.DirectoryWalker;

public abstract class AbstractAnalyzeTask
extends AbstractJQATask {
    private static final String CMDLINE_OPTION_RULEDIR = "r";
    private static final String CMDLINE_OPTION_GROUPS = "groups";
    private static final String CMDLINE_OPTION_CONSTRAINTS = "constraints";
    private static final String CMDLINE_OPTION_CONCEPTS = "concepts";
    private static final Log LOG = Log.getLog();
    private final RuleSetReader ruleSetReader = new CompoundRuleSetReader();
    private String ruleDirectory;
    private List<String> conceptIds;
    private List<String> constraintIds;
    private List<String> groupIds;

    protected RuleSet getAvailableRules() throws CliExecutionException {
        File selectedDirectory = new File(this.ruleDirectory);
        ArrayList<FileRuleSource> sources = new ArrayList<FileRuleSource>();
        List<File> ruleFiles = this.readRulesDirectory(selectedDirectory);
        for (File ruleFile : ruleFiles) {
            LOG.debug("Adding rules from file " + ruleFile.getAbsolutePath());
            sources.add(new FileRuleSource(ruleFile));
        }
        List ruleSources = this.rulePluginRepository.getRuleSources();
        sources.addAll(ruleSources);
        return this.ruleSetReader.read(sources);
    }

    protected RuleSelection getRuleSelection(RuleSet ruleSet) throws CliExecutionException {
        return RuleSelection.Builder.select(ruleSet, this.groupIds, this.constraintIds, this.conceptIds);
    }

    private List<File> readRulesDirectory(File rulesDirectory) throws CliExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new RuntimeException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        LOG.info("Reading rules from directory " + rulesDirectory.getAbsolutePath());
        final ArrayList<File> ruleFiles = new ArrayList<File>();
        try {
            new DirectoryWalker<File>(){

                protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
                    if (!file.isDirectory() && file.getName().endsWith(".xml")) {
                        results.add(file);
                    }
                }

                public void scan(File directory) throws IOException {
                    super.walk(directory, (Collection)ruleFiles);
                }
            }.scan(rulesDirectory);
            return ruleFiles;
        }
        catch (IOException e) {
            throw new CliExecutionException("Cannot read rules directory: " + rulesDirectory.getAbsolutePath(), e);
        }
    }

    @Override
    public void withOptions(CommandLine options) {
        this.ruleDirectory = this.getOptionValue(options, CMDLINE_OPTION_RULEDIR, "jqassistant/rules");
        this.groupIds = this.getOptionValues(options, CMDLINE_OPTION_GROUPS, Arrays.asList("default"));
        this.constraintIds = this.getOptionValues(options, CMDLINE_OPTION_CONSTRAINTS, Collections.emptyList());
        this.conceptIds = this.getOptionValues(options, CMDLINE_OPTION_CONCEPTS, Collections.emptyList());
    }

    @Override
    protected void addTaskOptions(List<Option> options) {
        OptionBuilder.withArgName((String)CMDLINE_OPTION_RULEDIR);
        OptionBuilder.withLongOpt((String)"ruleDirectory");
        OptionBuilder.withDescription((String)"The directory containing rules.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_RULEDIR));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_GROUPS);
        OptionBuilder.withDescription((String)"The groups to execute (default='default').");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_GROUPS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_CONSTRAINTS);
        OptionBuilder.withDescription((String)"The constraints to verify.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_CONSTRAINTS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_CONCEPTS);
        OptionBuilder.withDescription((String)"The concepts to apply.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_CONCEPTS));
    }
}

