/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli;

import com.buschmais.jqassistant.scm.cli.JQATask;
import com.buschmais.jqassistant.scm.cli.task.AnalyzeTask;
import com.buschmais.jqassistant.scm.cli.task.AvailableRulesTask;
import com.buschmais.jqassistant.scm.cli.task.AvailableScopesTask;
import com.buschmais.jqassistant.scm.cli.task.EffectiveRulesTask;
import com.buschmais.jqassistant.scm.cli.task.ReportTask;
import com.buschmais.jqassistant.scm.cli.task.ResetTask;
import com.buschmais.jqassistant.scm.cli.task.ScanTask;
import com.buschmais.jqassistant.scm.cli.task.ServerTask;
import com.google.common.base.CaseFormat;

public enum Task {
    SCAN{

        @Override
        public JQATask getTask() {
            return new ScanTask();
        }
    }
    ,
    AVAILABLE_SCOPES{

        @Override
        public JQATask getTask() {
            return new AvailableScopesTask();
        }
    }
    ,
    SERVER{

        @Override
        public JQATask getTask() {
            return new ServerTask();
        }
    }
    ,
    AVAILABLE_RULES{

        @Override
        public JQATask getTask() {
            return new AvailableRulesTask();
        }
    }
    ,
    EFFECTIVE_RULES{

        @Override
        public JQATask getTask() {
            return new EffectiveRulesTask();
        }
    }
    ,
    ANALYZE{

        @Override
        public JQATask getTask() {
            return new AnalyzeTask();
        }
    }
    ,
    RESET{

        @Override
        public JQATask getTask() {
            return new ResetTask();
        }
    }
    ,
    REPORT{

        @Override
        public JQATask getTask() {
            return new ReportTask();
        }
    };


    public abstract JQATask getTask();

    public static JQATask fromName(String name) {
        String formattedTaskName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        try {
            return Task.valueOf(formattedTaskName).getTask();
        }
        catch (IllegalArgumentException e) {
            System.exit(1);
            return null;
        }
    }
}

