/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.JQATask;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.cli.PluginClassLoader;
import com.buschmais.jqassistant.scm.cli.Task;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static final String ENV_JQASSISTANT_HOME = "JQASSISTANT_HOME";
    private static final String DIRECTORY_PLUGINS = "plugins";

    public static void main(String[] args) throws IOException {
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(Main.createPluginClassLoader());
        try {
            Main.interpretCommandLine(args, (PluginConfigurationReader)pluginConfigurationReader);
        }
        catch (CliExecutionException e) {
            Log.getLog().error(e.getMessage());
            System.exit(e.getExitCode());
        }
    }

    private static Options gatherOptions() {
        Options options = new Options();
        Main.gatherTasksOptions(options);
        Main.gatherStandardOptions(options);
        return options;
    }

    private static void gatherStandardOptions(Options options) {
        OptionBuilder.withArgName((String)"p");
        OptionBuilder.withDescription((String)"Path to property file; default is jqassistant.properties in the class path");
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"p"));
        options.addOption(new Option("help", "print this message"));
    }

    private static void gatherTasksOptions(Options options) {
        for (Task task : Task.values()) {
            for (Option option : task.getTask().getOptions()) {
                options.addOption(option);
            }
        }
    }

    private static String gatherTaskNames() {
        StringBuilder builder = new StringBuilder();
        for (Task task : Task.values()) {
            builder.append("'").append(task.name().toLowerCase()).append("' ");
        }
        return builder.toString().trim();
    }

    private static void interpretCommandLine(String[] arg, PluginConfigurationReader pluginConfigurationReader) throws CliExecutionException {
        BasicParser parser = new BasicParser();
        Options option = Main.gatherOptions();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(option, arg);
        }
        catch (ParseException e) {
            Main.printUsage(option, e.getMessage());
            System.exit(1);
        }
        List requestedTasks = commandLine.getArgList();
        if (requestedTasks.isEmpty()) {
            Main.printUsage(option, "A task must be specified, i.e. one  of " + Main.gatherTaskNames());
            System.exit(1);
        }
        for (String requestedTask : requestedTasks) {
            Main.executeTask(requestedTask, option, commandLine, pluginConfigurationReader);
        }
    }

    private static void executeTask(String taskName, Options option, CommandLine commandLine, PluginConfigurationReader pluginConfigurationReader) throws CliExecutionException {
        JQATask task = Task.fromName(taskName);
        if (task == null) {
            Main.printUsage(option, "Unknown task " + taskName);
            System.exit(1);
        }
        try {
            task.withStandardOptions(commandLine);
            task.withOptions(commandLine);
        }
        catch (CliConfigurationException e) {
            Main.printUsage(option, e.getMessage());
            System.exit(1);
        }
        Map<String, Object> properties = Main.readProperties(commandLine);
        task.initialize(pluginConfigurationReader, properties);
        task.run();
    }

    private static Map<String, Object> readProperties(CommandLine commandLine) throws CliConfigurationException {
        InputStream propertiesStream;
        Properties properties = new Properties();
        if (commandLine.hasOption("p")) {
            File propertyFile = new File(commandLine.getOptionValue("p"));
            if (!propertyFile.exists()) {
                throw new CliConfigurationException("Property file given by command line does not exist: " + propertyFile.getAbsolutePath());
            }
            try {
                propertiesStream = new FileInputStream(propertyFile);
            }
            catch (FileNotFoundException e) {
                throw new CliConfigurationException("Cannot open property file.", e);
            }
        } else {
            propertiesStream = Main.class.getResourceAsStream("/jqassistant.properties");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertiesStream != null) {
            try {
                properties.load(propertiesStream);
            }
            catch (IOException e) {
                throw new CliConfigurationException("Cannot load properties from file.", e);
            }
            for (String name : properties.stringPropertyNames()) {
                result.put(name, properties.getProperty(name));
            }
        }
        return result;
    }

    private static void printUsage(Options option, String errorMessage) {
        System.out.println(errorMessage);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Main.class.getCanonicalName(), option);
        System.out.println("Example: " + Main.class.getCanonicalName() + " scan -d target/classes,target/test-classes");
    }

    private static File getHomeDirectory() {
        String dirName = System.getenv(ENV_JQASSISTANT_HOME);
        if (dirName != null) {
            File dir = new File(dirName);
            if (dir.exists()) {
                Log.getLog().info("Using JQASSISTANT_HOME '" + dir.getAbsolutePath() + "'.");
                return dir;
            }
            Log.getLog().warn("JQASSISTANT_HOME '" + dir.getAbsolutePath() + "' points to a non-existing directory.");
            return null;
        }
        Log.getLog().warn("JQASSISTANT_HOME is not set.");
        return null;
    }

    private static ClassLoader createPluginClassLoader() {
        File pluginDirectory;
        ClassLoader parentClassLoader = JQATask.class.getClassLoader();
        File homeDirectory = Main.getHomeDirectory();
        if (homeDirectory != null && (pluginDirectory = new File(homeDirectory, DIRECTORY_PLUGINS)).exists()) {
            final ArrayList<URL> urls = new ArrayList<URL>();
            Path pluginDirectoryPath = pluginDirectory.toPath();
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().endsWith(".jar")) {
                        urls.add(file.toFile().toURI().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(pluginDirectoryPath, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read plugin directory.", e);
            }
            return new PluginClassLoader(urls, parentClassLoader);
        }
        return parentClassLoader;
    }
}

