/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongObjectHashMap<VALUE>
extends AbstractLongHopScotchCollection<VALUE>
implements PrimitiveLongObjectMap<VALUE> {
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongObjectHashMap(Table<VALUE> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public VALUE put(long key, VALUE value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, value, this);
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public VALUE get(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public VALUE remove(long key) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    @Override
    public void visitEntries(PrimitiveLongObjectVisitor<VALUE> visitor) {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long key = this.table.key(i);
            if (key == nullKey) continue;
            Object value = this.table.value(i);
            visitor.visited(key, value);
        }
    }
}

