/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongIntMap;
import org.neo4j.collection.primitive.PrimitiveLongIntVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongIntHashMap
extends AbstractLongHopScotchCollection<int[]>
implements PrimitiveLongIntMap {
    private final int[] transport = new int[1];
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongIntHashMap(Table<int[]> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public int put(long key, int value) {
        return this.unpack(HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, this.pack(value), this));
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public int get(long key) {
        return this.unpack((int[])HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int remove(long key) {
        return this.unpack((int[])HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    private int[] pack(int value) {
        this.transport[0] = value;
        return this.transport;
    }

    private int unpack(int[] result) {
        return result != null ? result[0] : -1;
    }

    @Override
    public void visitEntries(PrimitiveLongIntVisitor visitor) {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long key;
            int[] value = (int[])this.table.value(i);
            if (value == null || (key = this.table.key(i)) == nullKey) continue;
            visitor.visited(key, value[0]);
        }
    }
}

