/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.model.RepositoryArtifactDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactResolver;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.DefaultFileResource;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenIndex;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.xo.api.Query;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.MAVEN;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryScannerPlugin
extends AbstractScannerPlugin<URL, MavenRepositoryDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenRepositoryScannerPlugin.class);
    private static final String PROPERTY_NAME_DIRECTORY = "m2repo.directory";
    private static final String PROPERTY_NAME_DELETE_ARTIFACTS = "m2repo.delete.artifacts";
    public static final String DEFAULT_M2REPO_DIR = "./jqassistant/data/m2repo";
    private File localDirectory;
    private boolean deleteArtifactsAfterScan = false;

    public boolean accepts(URL item, String path, Scope scope) throws IOException {
        return MavenScope.REPOSITORY == scope;
    }

    private String getCoords(Artifact artifact, String version) {
        StringBuilder builder = new StringBuilder(artifact.getGroupId()).append(":");
        builder.append(artifact.getArtifactId()).append(":");
        builder.append(artifact.getExtension()).append(":");
        if (StringUtils.isNotBlank((String)artifact.getClassifier())) {
            builder.append(artifact.getClassifier()).append(":");
        }
        if (version == null) {
            builder.append(artifact.getVersion());
        } else {
            builder.append(version);
        }
        return builder.toString();
    }

    private MavenRepositoryDescriptor getRepositoryDescriptor(Store store, String url) {
        MavenRepositoryDescriptor repositoryDescriptor = (MavenRepositoryDescriptor)store.find(MavenRepositoryDescriptor.class, url);
        if (repositoryDescriptor == null) {
            repositoryDescriptor = (MavenRepositoryDescriptor)store.create(MavenRepositoryDescriptor.class);
            repositoryDescriptor.setUrl(url);
        }
        return repositoryDescriptor;
    }

    protected void initialize() {
        super.initialize();
        this.localDirectory = new File(DEFAULT_M2REPO_DIR);
        if (this.getProperties().containsKey(PROPERTY_NAME_DIRECTORY)) {
            this.localDirectory = new File(this.getProperties().get(PROPERTY_NAME_DIRECTORY).toString());
        }
        if (this.getProperties().containsKey(PROPERTY_NAME_DELETE_ARTIFACTS)) {
            this.deleteArtifactsAfterScan = BooleanUtils.toBoolean((String)Objects.toString(this.getProperties().get(PROPERTY_NAME_DELETE_ARTIFACTS)));
        }
    }

    private RepositoryArtifactDescriptor migrateToArtifactAndSetRelation(Store store, MavenRepositoryDescriptor repoDescriptor, long lastModified, Descriptor descriptor) {
        RepositoryArtifactDescriptor artifactDescriptor = (RepositoryArtifactDescriptor)store.addDescriptorType(descriptor, RepositoryArtifactDescriptor.class);
        artifactDescriptor.setLastModified(lastModified);
        artifactDescriptor.setContainingRepository(repoDescriptor);
        return artifactDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAndScan(Scanner scanner, MavenRepositoryDescriptor repoDescriptor, ArtifactResolver artifactResolver, ArtifactInfo artifactInfo) throws IOException {
        List<ArtifactResult> artifactResults = null;
        Store store = scanner.getContext().getStore();
        try {
            String groupId = artifactInfo.getFieldValue(MAVEN.GROUP_ID);
            String artifactId = artifactInfo.getFieldValue(MAVEN.ARTIFACT_ID);
            String classifier = artifactInfo.getFieldValue(MAVEN.CLASSIFIER);
            String packaging = artifactInfo.getFieldValue(MAVEN.PACKAGING);
            String version = artifactInfo.getFieldValue(MAVEN.VERSION);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
            artifactResults = artifactResolver.downloadArtifact((Artifact)artifact);
            for (ArtifactResult artifactResult : artifactResults) {
                Artifact resolvedArtifact = artifactResult.getArtifact();
                File artifactFile = resolvedArtifact.getFile();
                try {
                    DefaultFileResource fileResource = new DefaultFileResource(artifactFile);
                    Throwable throwable = null;
                    try {
                        long lastModified = artifactInfo.lastModified;
                        String coords = this.getCoords(resolvedArtifact, version);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("coords", coords);
                        params.put("lastModified", lastModified);
                        params.put("url", repoDescriptor.getUrl());
                        if (this.isArtifactInDb(store, params)) continue;
                        Descriptor descriptor = scanner.scan((Object)fileResource, artifactFile.getAbsolutePath(), null);
                        if (descriptor != null) {
                            RepositoryArtifactDescriptor artifactDescriptor = this.migrateToArtifactAndSetRelation(store, repoDescriptor, lastModified, descriptor);
                            artifactDescriptor.setClassifier(resolvedArtifact.getClassifier());
                            artifactDescriptor.setGroup(resolvedArtifact.getGroupId());
                            artifactDescriptor.setName(resolvedArtifact.getArtifactId());
                            artifactDescriptor.setType(resolvedArtifact.getExtension());
                            artifactDescriptor.setVersion(version);
                            artifactDescriptor.setMavenCoordinates(coords);
                            Query.Result queryResult = store.executeQuery("MATCH (n:RepositoryArtifact)<-[:CONTAINS_ARTIFACT]-(m:Maven:Repository) WHERE n.mavenCoordinates={coords} AND n.lastModified<>{lastModified} and m.url={url} RETURN n", params);
                            if (!queryResult.hasResult()) continue;
                            RepositoryArtifactDescriptor predecessorArtifactDescriptor = (RepositoryArtifactDescriptor)((Query.Result.CompositeRowObject)queryResult.getSingleResult()).get("n", RepositoryArtifactDescriptor.class);
                            artifactDescriptor.setPredecessorArtifact(predecessorArtifactDescriptor);
                            predecessorArtifactDescriptor.setContainingRepository(null);
                            continue;
                        }
                        LOGGER.debug("Could not scan artifact: " + artifactFile.getAbsoluteFile());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileResource == null) continue;
                        if (throwable != null) {
                            try {
                                fileResource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileResource.close();
                    }
                }
                finally {
                    if (artifactResult == null || !this.deleteArtifactsAfterScan) continue;
                    artifactFile.delete();
                }
            }
        }
        catch (ArtifactResolutionException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    private boolean isArtifactInDb(Store store, Map<String, Object> params) {
        Query.Result queryResult = store.executeQuery("MATCH (n:RepositoryArtifact)<-[:CONTAINS_ARTIFACT]-(m:Maven:Repository) WHERE n.mavenCoordinates={coords} and n.lastModified={lastModified} and m.url={url} RETURN count(n) as nodeCount;", params);
        Query.Result.CompositeRowObject rowObject = (Query.Result.CompositeRowObject)queryResult.getSingleResult();
        Long nodeCount = (Long)rowObject.get("nodeCount", Long.class);
        return nodeCount > 0L;
    }

    public MavenRepositoryDescriptor scan(URL item, String path, Scope scope, Scanner scanner) throws IOException {
        String userInfo = item.getUserInfo();
        String username = StringUtils.substringBefore((String)userInfo, (String)":");
        String password = StringUtils.substringAfter((String)userInfo, (String)":");
        if (!this.localDirectory.exists()) {
            LOGGER.info("Creating local maven repository directory {}", (Object)this.localDirectory.getAbsolutePath());
            this.localDirectory.mkdirs();
        }
        File localRepoDir = new File(this.localDirectory, DigestUtils.md5Hex((String)item.toString()));
        MavenIndex mavenIndex = new MavenIndex(item, localRepoDir, username, password);
        ArtifactResolver artifactResolver = new ArtifactResolver(item, localRepoDir, username, password);
        return this.scanRepository(item, scanner, mavenIndex, artifactResolver);
    }

    public MavenRepositoryDescriptor scanRepository(URL item, Scanner scanner, MavenIndex mavenIndex, ArtifactResolver artifactResolver) throws IOException {
        Store store = scanner.getContext().getStore();
        MavenRepositoryDescriptor repoDescriptor = this.getRepositoryDescriptor(store, item.toString());
        Date lastIndexUpdateTime = mavenIndex.getLastUpdateLocalRepo();
        Date lastScanTime = new Date(repoDescriptor.getLastScanDate());
        Date artifactsSince = lastIndexUpdateTime;
        if (lastIndexUpdateTime == null || lastIndexUpdateTime.after(lastScanTime)) {
            artifactsSince = lastScanTime;
        }
        mavenIndex.updateIndex();
        Iterable<ArtifactInfo> searchResponse = mavenIndex.getArtifactsSince(artifactsSince);
        for (ArtifactInfo ai : searchResponse) {
            this.resolveAndScan(scanner, repoDescriptor, artifactResolver, ai);
        }
        mavenIndex.closeCurrentIndexingContext();
        mavenIndex = null;
        repoDescriptor.setLastScanDate(System.currentTimeMillis());
        return repoDescriptor;
    }
}

