/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactResolver.class);
    private final RemoteRepository repository;
    private final RepositorySystem repositorySystem;
    private final DefaultRepositorySystemSession session;

    public ArtifactResolver(URL repositoryUrl, File localDirectory) {
        this(repositoryUrl, localDirectory, null, null);
    }

    public ArtifactResolver(URL repositoryUrl, File localDirectory, String username, String password) {
        String url = StringUtils.replace((String)repositoryUrl.toString(), (String)(repositoryUrl.getUserInfo() + "@"), (String)"");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Create new " + this.getClass().getSimpleName() + " for URL " + url);
        }
        AuthenticationBuilder authBuilder = new AuthenticationBuilder();
        if (username != null) {
            authBuilder.addUsername(username);
        }
        if (password != null) {
            authBuilder.addPassword(password);
        }
        Authentication auth = authBuilder.build();
        this.repository = new RemoteRepository.Builder("jqa", "default", url).setAuthentication(auth).build();
        this.repositorySystem = this.newRepositorySystem();
        this.session = this.newRepositorySystemSession(this.repositorySystem, localDirectory);
    }

    public List<ArtifactResult> downloadArtifact(Artifact artifact) throws ArtifactResolutionException {
        Set<ArtifactRequest> artifactRequests = this.newArtifactRequests(artifact);
        return this.repositorySystem.resolveArtifacts((RepositorySystemSession)this.session, artifactRequests);
    }

    private Set<ArtifactRequest> newArtifactRequests(Artifact artifact) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        List<RemoteRepository> repositories = Arrays.asList(this.repository);
        artifactRequest.setRepositories(repositories);
        HashSet<ArtifactRequest> requests = new HashSet<ArtifactRequest>();
        requests.add(artifactRequest);
        if ((artifact.getExtension() == null || "jar".equals(artifact.getExtension().toLowerCase())) && StringUtils.isBlank((String)artifact.getClassifier())) {
            ArtifactRequest pomRequest = new ArtifactRequest();
            DefaultArtifact pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, "pom", artifact.getVersion());
            pomRequest.setArtifact((Artifact)pomArtifact);
            pomRequest.setRepositories(repositories);
            requests.add(pomRequest);
        }
        return requests;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, File localDirectory) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localDirectory + "/repository");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }
}

