/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.facade;

import org.eclipse.tycho.core.facade.MavenLogger;

public class MultiLineLogger
implements MavenLogger {
    private final MavenLogger delegate;

    public MultiLineLogger(MavenLogger delegate) {
        this.delegate = delegate;
    }

    public void error(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.error(messageLine);
            ++n2;
        }
    }

    public void warn(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.warn(messageLine);
            ++n2;
        }
    }

    public void warn(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        int ix = 0;
        while (ix < messageLines.length - 1) {
            String messageLine = messageLines[ix];
            this.delegate.warn(messageLine);
            ++ix;
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.warn(lastMessageLine, cause);
        }
    }

    public void info(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.info(messageLine);
            ++n2;
        }
    }

    public void debug(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.debug(messageLine);
            ++n2;
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isExtendedDebugEnabled() {
        return this.delegate.isExtendedDebugEnabled();
    }
}

