/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.StringOption;

public final class AdditionalConfigParser
extends BaseOptionsParser<Config> {
    private final Config config;

    public AdditionalConfigParser(Config config) {
        super(new StringOption(Character.valueOf('p'), "additionalconfigfile", "schemacrawler.additional.config.properties"), new BooleanOption("noinfo"), new BooleanOption("sorttables"), new BooleanOption("sortcolumns"), new BooleanOption("sortinout"), new BooleanOption("portablenames"));
        this.config = config;
    }

    @Override
    public Config getOptions() throws SchemaCrawlerException {
        Config additionalConfig = new Config(this.config);
        String cfgFile = this.getStringValue("p");
        additionalConfig.putAll(Config.load(cfgFile));
        SchemaTextOptions textOptions = new SchemaTextOptions(additionalConfig);
        if (this.getBooleanValue("noinfo")) {
            textOptions.setNoInfo(true);
        }
        if (this.getBooleanValue("sorttables")) {
            textOptions.setAlphabeticalSortForTables(false);
        }
        if (this.getBooleanValue("sortcolumns")) {
            textOptions.setAlphabeticalSortForTableColumns(true);
        }
        if (this.getBooleanValue("sortinout")) {
            textOptions.setAlphabeticalSortForRoutineColumns(true);
        }
        if (this.getBooleanValue("portablenames")) {
            textOptions.setHideConstraintNames(true);
            textOptions.setHideForeignKeyNames(true);
            textOptions.setHideIndexNames(true);
            textOptions.setHidePrimaryKeyNames(true);
            textOptions.setHideTriggerNames(true);
            textOptions.setHideRoutineSpecificNames(true);
            textOptions.setShowUnqualifiedNames(true);
        }
        additionalConfig.putAll(textOptions.toConfig());
        return additionalConfig;
    }
}

