/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;

public final class WeakAssociation
implements ColumnReference,
Comparable<ColumnReference> {
    private static final long serialVersionUID = -4411771492159843382L;
    private final Column foreignKeyColumn;
    private final Column primaryKeyColumn;

    WeakAssociation(Column primaryKeyColumn, Column foreignKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
        this.foreignKeyColumn = foreignKeyColumn;
    }

    @Override
    public int compareTo(ColumnReference o) {
        int compare = 0;
        if (compare == 0) {
            compare = this.primaryKeyColumn.compareTo(o.getPrimaryKeyColumn());
        }
        if (compare == 0) {
            compare = this.foreignKeyColumn.compareTo(o.getForeignKeyColumn());
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeakAssociation other = (WeakAssociation)obj;
        if (this.foreignKeyColumn == null ? other.foreignKeyColumn != null : !this.foreignKeyColumn.equals(other.foreignKeyColumn)) {
            return false;
        }
        return !(this.primaryKeyColumn == null ? other.primaryKeyColumn != null : !this.primaryKeyColumn.equals(other.primaryKeyColumn));
    }

    @Override
    public Column getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    @Override
    public Column getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.foreignKeyColumn == null ? 0 : this.foreignKeyColumn.hashCode());
        result = 31 * result + (this.primaryKeyColumn == null ? 0 : this.primaryKeyColumn.hashCode());
        return result;
    }

    public String toString() {
        return this.primaryKeyColumn + " --> " + this.foreignKeyColumn;
    }
}

