/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.MutableForeignKeyColumnReference;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObject;
import schemacrawler.utility.CompareUtility;

class MutableForeignKey
extends AbstractNamedObjectWithAttributes
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private final SortedSet<MutableForeignKeyColumnReference> columnReferences = new TreeSet<MutableForeignKeyColumnReference>();
    private ForeignKeyUpdateRule updateRule = ForeignKeyUpdateRule.unknown;
    private ForeignKeyUpdateRule deleteRule = ForeignKeyUpdateRule.unknown;
    private ForeignKeyDeferrability deferrability = ForeignKeyDeferrability.unknown;

    MutableForeignKey(String name) {
        super(name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        ForeignKey other = (ForeignKey)obj;
        List<ForeignKeyColumnReference> thisColumnReferences = this.getColumnReferences();
        List<ForeignKeyColumnReference> otherColumnReferences = other.getColumnReferences();
        return CompareUtility.compareLists(thisColumnReferences, otherColumnReferences);
    }

    @Override
    public List<ForeignKeyColumnReference> getColumnReferences() {
        return new ArrayList<ForeignKeyColumnReference>(this.columnReferences);
    }

    @Override
    public final ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public final ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public final ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    void addColumnReference(int keySequence, Column pkColumn, Column fkColumn) {
        MutableForeignKeyColumnReference fkColumnReference = new MutableForeignKeyColumnReference();
        fkColumnReference.setKeySequence(keySequence);
        fkColumnReference.setPrimaryKeyColumn(pkColumn);
        fkColumnReference.setForeignKeyColumn(fkColumn);
        this.columnReferences.add(fkColumnReference);
    }

    final void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    final void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    final void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }
}

