/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.schema.NamedObject;
import schemacrawler.utility.NamedObjectSort;

abstract class AbstractNamedObject
implements NamedObject {
    private static final long serialVersionUID = -1486322887991472729L;
    private final String name;

    AbstractNamedObject(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        return NamedObjectSort.alphabetical.compare(this, obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNamedObject)) {
            return false;
        }
        AbstractNamedObject other = (AbstractNamedObject)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getLookupKey() {
        return this.getFullName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final String toString() {
        return this.getFullName();
    }
}

