/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.rdbms.impl.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.rdbms.api.model.BaseColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ColumnTypeDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ConnectionDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ForeignKeyDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ForeignKeyReferenceDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.FunctionDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.IndexDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.IndexOnColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.OnColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.PrimaryKeyDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.PrimaryKeyOnColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ProcedureDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.RoutineColumnDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.RoutineDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.SchemaDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.SequenceDesriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.TableDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.TriggerDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.api.model.ViewDescriptor;
import com.buschmais.jqassistant.plugin.rdbms.impl.scanner.BundledDriver;
import com.buschmais.jqassistant.plugin.rdbms.impl.scanner.InfoLevelOption;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import schemacrawler.schema.BaseColumn;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.FunctionColumnType;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schema.RoutineColumnType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.utility.SchemaCrawlerUtility;

public abstract class AbstractSchemaScannerPlugin<I, D extends ConnectionDescriptor>
extends AbstractScannerPlugin<I, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchemaScannerPlugin.class);

    public Class<? extends I> getType() {
        return this.getTypeParameter(AbstractSchemaScannerPlugin.class, 0);
    }

    public Class<? extends D> getDescriptorType() {
        return this.getTypeParameter(AbstractSchemaScannerPlugin.class, 1);
    }

    protected List<SchemaDescriptor> scanConnection(String url, String user, String password, String infoLevelName, String bundledDriverName, Properties properties, Store store) throws IOException {
        Catalog catalog = this.getCatalog(url, user, password, infoLevelName, bundledDriverName, properties);
        return this.createSchemas(catalog, store);
    }

    protected Catalog getCatalog(String url, String user, String password, String infoLevelName, String bundledDriverName, Properties properties) throws IOException {
        Catalog catalog;
        InfoLevel level = InfoLevel.valueOf(infoLevelName.toLowerCase());
        SchemaInfoLevel schemaInfoLevel = level.getSchemaInfoLevel();
        for (InfoLevelOption option : InfoLevelOption.values()) {
            String value = properties.getProperty(option.getPropertyName());
            if (value == null) continue;
            LOGGER.info("Setting option " + option.name() + "=" + value);
            option.set(schemaInfoLevel, Boolean.valueOf(value.toLowerCase()));
        }
        SchemaCrawlerOptions options = bundledDriverName != null ? this.getOptions(bundledDriverName, level) : new SchemaCrawlerOptions();
        options.setSchemaInfoLevel(schemaInfoLevel);
        LOGGER.info("Scanning database schemas on '" + url + "' (user='" + user + "', info level='" + level.name() + "')");
        try (Connection connection = DriverManager.getConnection(url, user, password);){
            catalog = SchemaCrawlerUtility.getCatalog(connection, options);
        }
        catch (SQLException | SchemaCrawlerException e) {
            throw new IOException(String.format("Cannot scan schema (url='%s', user='%s'", url, user), e);
        }
        return catalog;
    }

    private SchemaCrawlerOptions getOptions(String bundledDriverName, InfoLevel level) throws IOException {
        for (BundledDriver bundledDriver : BundledDriver.values()) {
            if (!bundledDriver.name().toLowerCase().equals(bundledDriverName.toLowerCase())) continue;
            return bundledDriver.getOptions(level);
        }
        throw new IOException("Unknown bundled driver name '" + bundledDriverName + "', supported values are " + Arrays.asList(BundledDriver.values()));
    }

    private List<SchemaDescriptor> createSchemas(Catalog catalog, Store store) throws IOException {
        ArrayList<SchemaDescriptor> schemaDescriptors = new ArrayList<SchemaDescriptor>();
        HashMap<String, ColumnTypeDescriptor> columnTypes = new HashMap<String, ColumnTypeDescriptor>();
        HashMap<Column, ColumnDescriptor> allColumns = new HashMap<Column, ColumnDescriptor>();
        HashSet<ForeignKey> allForeignKeys = new HashSet<ForeignKey>();
        for (Schema schema : catalog.getSchemas()) {
            SchemaDescriptor schemaDescriptor = (SchemaDescriptor)store.create(SchemaDescriptor.class);
            schemaDescriptor.setName(schema.getName());
            this.createTables(catalog, schema, schemaDescriptor, columnTypes, allColumns, allForeignKeys, store);
            this.createSequences(catalog.getSequences(schema), schemaDescriptor, store);
            this.createRoutines(catalog.getRoutines(schema), schemaDescriptor, columnTypes, store);
            schemaDescriptors.add(schemaDescriptor);
        }
        this.createForeignKeys(allForeignKeys, allColumns, store);
        return schemaDescriptors;
    }

    private void createTables(Catalog catalog, Schema schema, SchemaDescriptor schemaDescriptor, Map<String, ColumnTypeDescriptor> columnTypes, Map<Column, ColumnDescriptor> allColumns, Set<ForeignKey> allForeignKeys, Store store) {
        for (Table table : catalog.getTables(schema)) {
            TableDescriptor tableDescriptor = this.getTableDescriptor(table, schemaDescriptor, store);
            HashMap<String, ColumnDescriptor> localColumns = new HashMap<String, ColumnDescriptor>();
            for (Column column : table.getColumns()) {
                ColumnDescriptor columnDescriptor = this.createColumnDescriptor(column, ColumnDescriptor.class, columnTypes, store);
                columnDescriptor.setDefaultValue(column.getDefaultValue());
                columnDescriptor.setGenerated(column.isGenerated());
                columnDescriptor.setPartOfIndex(column.isPartOfIndex());
                columnDescriptor.setPartOfPrimaryKey(column.isPartOfPrimaryKey());
                columnDescriptor.setPartOfForeignKey(column.isPartOfForeignKey());
                columnDescriptor.setAutoIncremented(column.isAutoIncremented());
                tableDescriptor.getColumns().add(columnDescriptor);
                localColumns.put(column.getName(), columnDescriptor);
                allColumns.put(column, columnDescriptor);
            }
            PrimaryKey primaryKey = table.getPrimaryKey();
            if (primaryKey != null) {
                PrimaryKeyDescriptor primaryKeyDescriptor = this.storeIndex(primaryKey, tableDescriptor, localColumns, PrimaryKeyDescriptor.class, PrimaryKeyOnColumnDescriptor.class, store);
                tableDescriptor.setPrimaryKey(primaryKeyDescriptor);
            }
            for (Index index : table.getIndices()) {
                IndexDescriptor indexDescriptor = this.storeIndex(index, tableDescriptor, localColumns, IndexDescriptor.class, IndexOnColumnDescriptor.class, store);
                tableDescriptor.getIndices().add(indexDescriptor);
            }
            for (Trigger trigger : table.getTriggers()) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)store.create(TriggerDescriptor.class);
                triggerDescriptor.setName(trigger.getName());
                triggerDescriptor.setActionCondition(trigger.getActionCondition());
                triggerDescriptor.setActionOrder(trigger.getActionOrder());
                triggerDescriptor.setActionOrientation(trigger.getActionOrientation().name());
                triggerDescriptor.setActionStatement(trigger.getActionStatement());
                triggerDescriptor.setConditionTiming(trigger.getConditionTiming().name());
                triggerDescriptor.setEventManipulationTime(trigger.getEventManipulationType().name());
                tableDescriptor.getTriggers().add(triggerDescriptor);
            }
            allForeignKeys.addAll(table.getForeignKeys());
        }
    }

    private <T extends BaseColumnDescriptor> T createColumnDescriptor(BaseColumn column, Class<T> descriptorType, Map<String, ColumnTypeDescriptor> columnTypes, Store store) {
        BaseColumnDescriptor columnDescriptor = (BaseColumnDescriptor)store.create(descriptorType);
        columnDescriptor.setName(column.getName());
        columnDescriptor.setNullable(column.isNullable());
        columnDescriptor.setSize(column.getSize());
        columnDescriptor.setDecimalDigits(column.getDecimalDigits());
        ColumnDataType columnDataType = column.getColumnDataType();
        ColumnTypeDescriptor columnTypeDescriptor = this.getColumnTypeDescriptor(columnDataType, columnTypes, store);
        columnDescriptor.setColumnType(columnTypeDescriptor);
        return (T)columnDescriptor;
    }

    private void createForeignKeys(Set<ForeignKey> allForeignKeys, Map<Column, ColumnDescriptor> allColumns, Store store) {
        for (ForeignKey foreignKey : allForeignKeys) {
            ForeignKeyDescriptor foreignKeyDescriptor = (ForeignKeyDescriptor)store.create(ForeignKeyDescriptor.class);
            foreignKeyDescriptor.setName(foreignKey.getName());
            foreignKeyDescriptor.setDeferrability(foreignKey.getDeferrability().name());
            foreignKeyDescriptor.setDeleteRule(foreignKey.getDeleteRule().name());
            foreignKeyDescriptor.setUpdateRule(foreignKey.getUpdateRule().name());
            for (ForeignKeyColumnReference columnReference : foreignKey.getColumnReferences()) {
                ForeignKeyReferenceDescriptor keyReferenceDescriptor = (ForeignKeyReferenceDescriptor)store.create(ForeignKeyReferenceDescriptor.class);
                Column foreignKeyColumn = columnReference.getForeignKeyColumn();
                ColumnDescriptor foreignKeyColumnDescriptor = allColumns.get(foreignKeyColumn);
                keyReferenceDescriptor.setForeignKeyColumn(foreignKeyColumnDescriptor);
                Column primaryKeyColumn = columnReference.getPrimaryKeyColumn();
                ColumnDescriptor primaryKeyColumnDescriptor = allColumns.get(primaryKeyColumn);
                keyReferenceDescriptor.setPrimaryKeyColumn(primaryKeyColumnDescriptor);
                foreignKeyDescriptor.getForeignKeyReferences().add(keyReferenceDescriptor);
            }
        }
    }

    private void createRoutines(Collection<Routine> routines, SchemaDescriptor schemaDescriptor, Map<String, ColumnTypeDescriptor> columnTypes, Store store) throws IOException {
        for (Routine routine : routines) {
            String returnType;
            RoutineDescriptor routineDescriptor;
            switch (routine.getRoutineType()) {
                case procedure: {
                    routineDescriptor = (RoutineDescriptor)store.create(ProcedureDescriptor.class);
                    returnType = ((ProcedureReturnType)routine.getReturnType()).name();
                    schemaDescriptor.getProcedures().add((ProcedureDescriptor)routineDescriptor);
                    break;
                }
                case function: {
                    routineDescriptor = (RoutineDescriptor)store.create(FunctionDescriptor.class);
                    returnType = ((FunctionReturnType)routine.getReturnType()).name();
                    schemaDescriptor.getFunctions().add((FunctionDescriptor)routineDescriptor);
                    break;
                }
                case unknown: {
                    routineDescriptor = (RoutineDescriptor)store.create(RoutineDescriptor.class);
                    returnType = null;
                    schemaDescriptor.getUnknownRoutines().add(routineDescriptor);
                    break;
                }
                default: {
                    throw new IOException("Unsupported routine type " + (Object)((Object)routine.getRoutineType()));
                }
            }
            routineDescriptor.setName(routine.getName());
            routineDescriptor.setReturnType(returnType);
            routineDescriptor.setBodyType(routine.getRoutineBodyType().name());
            routineDescriptor.setDefinition(routine.getDefinition());
            for (RoutineColumn<? extends Routine> routineColumn : routine.getColumns()) {
                RoutineColumnDescriptor columnDescriptor = this.createColumnDescriptor(routineColumn, RoutineColumnDescriptor.class, columnTypes, store);
                routineDescriptor.getColumns().add(columnDescriptor);
                RoutineColumnType columnType = routineColumn.getColumnType();
                if (columnType instanceof ProcedureColumnType) {
                    ProcedureColumnType procedureColumnType = (ProcedureColumnType)columnType;
                    columnDescriptor.setType(procedureColumnType.name());
                    continue;
                }
                if (columnType instanceof FunctionColumnType) {
                    FunctionColumnType functionColumnType = (FunctionColumnType)columnType;
                    columnDescriptor.setType(functionColumnType.name());
                    continue;
                }
                throw new IOException("Unsupported routine column type " + columnType.getClass().getName());
            }
        }
    }

    private void createSequences(Collection<Sequence> sequences, SchemaDescriptor schemaDescriptor, Store store) {
        for (Sequence sequence : sequences) {
            SequenceDesriptor sequenceDesriptor = (SequenceDesriptor)store.create(SequenceDesriptor.class);
            sequenceDesriptor.setName(sequence.getName());
            sequenceDesriptor.setIncrement(sequence.getIncrement());
            sequenceDesriptor.setMinimumValue(sequence.getMinimumValue().longValue());
            sequenceDesriptor.setMaximumValue(sequence.getMaximumValue().longValue());
            sequenceDesriptor.setCycle(sequence.isCycle());
            schemaDescriptor.getSequences().add(sequenceDesriptor);
        }
    }

    private TableDescriptor getTableDescriptor(Table table, SchemaDescriptor schemaDescriptor, Store store) {
        TableDescriptor tableDescriptor;
        if (table instanceof View) {
            View view = (View)table;
            ViewDescriptor viewDescriptor = (ViewDescriptor)store.create(ViewDescriptor.class);
            viewDescriptor.setUpdatable(view.isUpdatable());
            CheckOptionType checkOption = view.getCheckOption();
            if (checkOption != null) {
                viewDescriptor.setCheckOption(checkOption.name());
            }
            schemaDescriptor.getViews().add(viewDescriptor);
            tableDescriptor = viewDescriptor;
        } else {
            tableDescriptor = (TableDescriptor)store.create(TableDescriptor.class);
            schemaDescriptor.getTables().add(tableDescriptor);
        }
        tableDescriptor.setName(table.getName());
        return tableDescriptor;
    }

    private <I extends IndexDescriptor> I storeIndex(Index index, TableDescriptor tableDescriptor, Map<String, ColumnDescriptor> columns, Class<I> indexType, Class<? extends OnColumnDescriptor> onColumnType, Store store) {
        IndexDescriptor indexDescriptor = (IndexDescriptor)store.create(indexType);
        indexDescriptor.setName(index.getName());
        indexDescriptor.setUnique(index.isUnique());
        indexDescriptor.setCardinality(index.getCardinality());
        indexDescriptor.setIndexType(index.getIndexType().name());
        indexDescriptor.setPages(index.getPages());
        for (IndexColumn indexColumn : index.getColumns()) {
            ColumnDescriptor columnDescriptor = columns.get(indexColumn.getName());
            OnColumnDescriptor onColumnDescriptor = (OnColumnDescriptor)store.create((Descriptor)indexDescriptor, onColumnType, (Descriptor)columnDescriptor);
            onColumnDescriptor.setIndexOrdinalPosition(indexColumn.getIndexOrdinalPosition());
            onColumnDescriptor.setSortSequence(indexColumn.getSortSequence().name());
        }
        return (I)indexDescriptor;
    }

    private ColumnTypeDescriptor getColumnTypeDescriptor(ColumnDataType columnDataType, Map<String, ColumnTypeDescriptor> columnTypes, Store store) {
        String databaseSpecificTypeName = columnDataType.getDatabaseSpecificTypeName();
        ColumnTypeDescriptor columnTypeDescriptor = columnTypes.get(databaseSpecificTypeName);
        if (columnTypeDescriptor == null) {
            columnTypeDescriptor = (ColumnTypeDescriptor)store.find(ColumnTypeDescriptor.class, databaseSpecificTypeName);
            if (columnTypeDescriptor == null) {
                columnTypeDescriptor = (ColumnTypeDescriptor)store.create(ColumnTypeDescriptor.class);
                columnTypeDescriptor.setDatabaseType(databaseSpecificTypeName);
                columnTypeDescriptor.setAutoIncrementable(columnDataType.isAutoIncrementable());
                columnTypeDescriptor.setCaseSensitive(columnDataType.isCaseSensitive());
                columnTypeDescriptor.setPrecision(columnDataType.getPrecision());
                columnTypeDescriptor.setMinimumScale(columnDataType.getMinimumScale());
                columnTypeDescriptor.setMaximumScale(columnDataType.getMaximumScale());
                columnTypeDescriptor.setFixedPrecisionScale(columnDataType.isFixedPrecisionScale());
                columnTypeDescriptor.setNumericPrecisionRadix(columnDataType.getNumPrecisionRadix());
                columnTypeDescriptor.setUnsigned(columnDataType.isUnsigned());
                columnTypeDescriptor.setUserDefined(columnDataType.isUserDefined());
                columnTypeDescriptor.setNullable(columnDataType.isNullable());
            }
            columnTypes.put(databaseSpecificTypeName, columnTypeDescriptor);
        }
        return columnTypeDescriptor;
    }
}

