/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaClassesDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.junit.api.scanner.JunitScope;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.AbstractMavenProjectScannerPlugin;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.ArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectScannerPlugin
extends AbstractMavenProjectScannerPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectScannerPlugin.class);

    public boolean accepts(MavenProject item, String path, Scope scope) throws IOException {
        return true;
    }

    public MavenProjectDirectoryDescriptor scan(MavenProject project, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        MavenProjectDirectoryDescriptor projectDescriptor = this.resolveProject(project, MavenProjectDirectoryDescriptor.class, context);
        HashMap<ArtifactFileDescriptor, Artifact> mainArtifactDependencies = new HashMap<ArtifactFileDescriptor, Artifact>();
        HashMap<ArtifactFileDescriptor, Artifact> testArtifactDependencies = new HashMap<ArtifactFileDescriptor, Artifact>();
        for (Artifact dependency : project.getDependencyArtifacts()) {
            ArtifactFileDescriptor dependencyDescriptor = (ArtifactFileDescriptor)ArtifactResolver.resolve(new ArtifactResolver.ArtifactCoordinates(dependency, false), JavaArtifactFileDescriptor.class, scanner.getContext());
            if (!"test".equals(dependency.getScope())) {
                mainArtifactDependencies.put(dependencyDescriptor, dependency);
            }
            testArtifactDependencies.put(dependencyDescriptor, dependency);
        }
        Artifact artifact = project.getArtifact();
        JavaClassesDirectoryDescriptor mainArtifactDescriptor = ArtifactResolver.resolve(new ArtifactResolver.ArtifactCoordinates(artifact, false), JavaClassesDirectoryDescriptor.class, scanner.getContext());
        this.addDependencies((ArtifactFileDescriptor)mainArtifactDescriptor, mainArtifactDependencies, scanner.getContext());
        this.scanClassesDirectory(projectDescriptor, mainArtifactDescriptor, false, project.getBuild().getOutputDirectory(), scanner);
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        if (testOutputDirectory != null) {
            JavaClassesDirectoryDescriptor testArtifactDescriptor = ArtifactResolver.resolve(new ArtifactResolver.ArtifactCoordinates(artifact, true), JavaClassesDirectoryDescriptor.class, scanner.getContext());
            testArtifactDependencies.put((ArtifactFileDescriptor)mainArtifactDescriptor, artifact);
            this.addDependencies((ArtifactFileDescriptor)testArtifactDescriptor, testArtifactDependencies, scanner.getContext());
            this.scanClassesDirectory(projectDescriptor, testArtifactDescriptor, true, testOutputDirectory, scanner);
        }
        this.addProjectDetails(project, projectDescriptor, scanner);
        this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/surefire-reports", (Scope)JunitScope.TESTREPORTS, scanner);
        this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/failsafe-reports", (Scope)JunitScope.TESTREPORTS, scanner);
        List scanIncludes = (List)this.getProperty(ScanInclude.class.getName(), List.class);
        if (scanIncludes != null) {
            for (ScanInclude scanInclude : scanIncludes) {
                String scopeName = scanInclude.getScope();
                Scope includeScope = scanner.resolveScope(scopeName);
                this.scanPath(projectDescriptor, scanInclude.getPath(), includeScope, scanner);
            }
        }
        return projectDescriptor;
    }

    private void addProjectDetails(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        ScannerContext scannerContext = scanner.getContext();
        this.addParent(project, projectDescriptor, scannerContext);
        this.addModules(project, projectDescriptor, scannerContext);
        this.addModel(project, projectDescriptor, scanner);
    }

    private void addModel(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        File pomXmlFile = project.getFile();
        MavenPomXmlDescriptor mavenPomXmlDescriptor = (MavenPomXmlDescriptor)scanner.scan((Object)pomXmlFile, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        projectDescriptor.setModel(mavenPomXmlDescriptor);
    }

    private void addParent(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            MavenProjectDescriptor parentDescriptor = this.resolveProject(parent, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.setParent(parentDescriptor);
        }
    }

    private void addModules(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        File projectDirectory = project.getBasedir();
        HashSet<File> modules = new HashSet<File>();
        for (String moduleName : project.getModules()) {
            File module = new File(projectDirectory, moduleName);
            modules.add(module);
        }
        for (MavenProject module : project.getCollectedProjects()) {
            if (!modules.contains(module.getBasedir())) continue;
            MavenProjectDescriptor moduleDescriptor = this.resolveProject(module, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void addDependencies(ArtifactFileDescriptor artifactDescriptor, Map<ArtifactFileDescriptor, Artifact> dependencies, ScannerContext scannerContext) {
        for (Map.Entry<ArtifactFileDescriptor, Artifact> entry : dependencies.entrySet()) {
            ArtifactFileDescriptor dependencyDescriptor = entry.getKey();
            Artifact dependency = entry.getValue();
            DependsOnDescriptor dependsOnDescriptor = (DependsOnDescriptor)scannerContext.getStore().create((Descriptor)artifactDescriptor, DependsOnDescriptor.class, (Descriptor)dependencyDescriptor);
            dependsOnDescriptor.setScope(dependency.getScope());
            dependsOnDescriptor.setOptional(dependency.isOptional());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanClassesDirectory(MavenProjectDirectoryDescriptor projectDescriptor, JavaClassesDirectoryDescriptor artifactDescriptor, boolean testJar, String directoryName, Scanner scanner) {
        File directory = new File(directoryName);
        if (directory.exists()) {
            projectDescriptor.getCreatesArtifacts().add((ArtifactFileDescriptor)artifactDescriptor);
            scanner.getContext().push(JavaClassesDirectoryDescriptor.class, (Object)artifactDescriptor);
            try {
                this.scanPath(projectDescriptor, directoryName, (Scope)JavaScope.CLASSPATH, scanner);
            }
            finally {
                scanner.getContext().pop(JavaClassesDirectoryDescriptor.class);
            }
        }
    }

    private void scanPath(MavenProjectDirectoryDescriptor projectDescriptor, String path, Scope scope, Scanner scanner) {
        File file = new File(path);
        if (file.exists()) {
            this.scanPath(projectDescriptor, file, path, scope, scanner);
        } else {
            LOGGER.debug(file.getAbsolutePath() + " does not exist, skipping.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanPath(MavenProjectDirectoryDescriptor projectDescriptor, File directory, String path, Scope scope, Scanner scanner) {
        scanner.getContext().push(MavenProjectDirectoryDescriptor.class, (Object)projectDescriptor);
        try {
            FileDescriptor descriptor = (FileDescriptor)scanner.scan((Object)directory, path, scope);
            if (descriptor != null) {
                projectDescriptor.getContains().add(descriptor);
            }
        }
        finally {
            scanner.getContext().pop(MavenProjectDirectoryDescriptor.class);
        }
    }
}

