/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactDescriptor;
import com.buschmais.xo.api.Query;
import java.util.HashMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;

public class ArtifactResolver {
    static <A extends ArtifactDescriptor> A resolve(Coordinates coordinates, Class<A> descriptorType, ScannerContext scannerContext) {
        Object artifactDescriptor;
        Store store = scannerContext.getStore();
        String id = coordinates.getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fqn", id);
        Query.Result result = store.executeQuery("MATCH (a:Artifact) WHERE a.fqn={fqn} RETURN a", params);
        if (!result.hasResult()) {
            artifactDescriptor = ArtifactResolver.createArtifactDescriptor(coordinates, descriptorType, scannerContext);
        } else {
            artifactDescriptor = (ArtifactDescriptor)((Query.Result.CompositeRowObject)result.getSingleResult()).get("a", ArtifactDescriptor.class);
            if (!descriptorType.isAssignableFrom(artifactDescriptor.getClass())) {
                return (A)((ArtifactDescriptor)store.migrate((Descriptor)artifactDescriptor, descriptorType, new Class[0]));
            }
        }
        return (A)((ArtifactDescriptor)descriptorType.cast(artifactDescriptor));
    }

    private static <A extends ArtifactDescriptor> A createArtifactDescriptor(Coordinates coordinates, Class<A> descriptorType, ScannerContext scannerContext) {
        String id = coordinates.getId();
        ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)scannerContext.getStore().create(descriptorType, id);
        artifactDescriptor.setGroup(coordinates.getGroupId());
        artifactDescriptor.setName(coordinates.getArtifactId());
        if (coordinates.getVersion() == null) {
            artifactDescriptor.setVersion(coordinates.getVersion());
        }
        artifactDescriptor.setVersion(coordinates.getVersion());
        artifactDescriptor.setClassifier(coordinates.getClassifier());
        artifactDescriptor.setType(coordinates.getType());
        return (A)artifactDescriptor;
    }

    private static String createId(Coordinates coordinates) {
        StringBuffer id = new StringBuffer();
        if (coordinates.getGroupId() != null) {
            id.append(coordinates.getGroupId());
        }
        id.append(':');
        id.append(coordinates.getArtifactId());
        id.append(':');
        id.append(coordinates.getType());
        String classifier = coordinates.getClassifier();
        if (classifier != null) {
            id.append(':');
            id.append(classifier);
        }
        id.append(':');
        if (coordinates.getVersion() != null) {
            id.append(coordinates.getVersion());
        }
        return id.toString();
    }

    static class DependencyCoordinates
    implements Coordinates {
        private Dependency dependency;

        DependencyCoordinates(Dependency dependency) {
            this.dependency = dependency;
        }

        @Override
        public String getGroupId() {
            return this.dependency.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.dependency.getArtifactId();
        }

        @Override
        public String getClassifier() {
            return this.dependency.getClassifier();
        }

        @Override
        public String getType() {
            return this.dependency.getType();
        }

        @Override
        public String getVersion() {
            return this.dependency.getVersion();
        }

        @Override
        public String getId() {
            return ArtifactResolver.createId(this);
        }
    }

    static class ArtifactCoordinates
    implements Coordinates {
        public static final String ARTIFACTTYPE_TEST_JAR = "test-jar";
        private Artifact artifact;
        private boolean testJar;

        ArtifactCoordinates(Artifact artifact, boolean testJar) {
            this.artifact = artifact;
            this.testJar = testJar;
        }

        @Override
        public String getGroupId() {
            return this.artifact.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.artifact.getArtifactId();
        }

        @Override
        public String getClassifier() {
            return this.artifact.getClassifier();
        }

        @Override
        public String getType() {
            return this.testJar ? ARTIFACTTYPE_TEST_JAR : this.artifact.getType();
        }

        @Override
        public String getVersion() {
            return this.artifact.getVersion();
        }

        @Override
        public String getId() {
            return ArtifactResolver.createId(this);
        }
    }

    static interface Coordinates {
        public String getGroupId();

        public String getArtifactId();

        public String getClassifier();

        public String getType();

        public String getVersion();

        public String getId();
    }
}

