/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArrayValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.BaseDependencyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.maven3.api.model.BaseProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ConfigurableDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationFileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationOSDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenConfigurationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenExecutionGoalDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenLicenseDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenModuleDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginExecutionDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileActivationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.PomManagesDependencyDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ProfileDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ProfileManagesDependencyDescriptor;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.ArtifactResolver;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.scanner.XmlScope;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractMavenPomScannerPlugin
extends AbstractScannerPlugin<FileResource, MavenPomXmlDescriptor> {
    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    public Class<? extends MavenPomXmlDescriptor> getDescriptorType() {
        return MavenPomXmlDescriptor.class;
    }

    private void addActivation(MavenProfileDescriptor mavenProfileDescriptor, Activation activation, Store store) {
        ActivationProperty property;
        ActivationOS os;
        if (null == activation) {
            return;
        }
        MavenProfileActivationDescriptor profileActivationDescriptor = (MavenProfileActivationDescriptor)store.create(MavenProfileActivationDescriptor.class);
        mavenProfileDescriptor.setActivation(profileActivationDescriptor);
        profileActivationDescriptor.setJdk(activation.getJdk());
        profileActivationDescriptor.setActiveByDefault(activation.isActiveByDefault());
        ActivationFile activationFile = activation.getFile();
        if (null != activationFile) {
            MavenActivationFileDescriptor activationFileDescriptor = (MavenActivationFileDescriptor)store.create(MavenActivationFileDescriptor.class);
            profileActivationDescriptor.setActivationFile(activationFileDescriptor);
            activationFileDescriptor.setExists(activationFile.getExists());
            activationFileDescriptor.setMissing(activationFile.getMissing());
        }
        if (null != (os = activation.getOs())) {
            MavenActivationOSDescriptor osDescriptor = (MavenActivationOSDescriptor)store.create(MavenActivationOSDescriptor.class);
            profileActivationDescriptor.setActivationOS(osDescriptor);
            osDescriptor.setArch(os.getArch());
            osDescriptor.setFamily(os.getFamily());
            osDescriptor.setName(os.getName());
            osDescriptor.setVersion(os.getVersion());
        }
        if (null != (property = activation.getProperty())) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            profileActivationDescriptor.setProperty(propertyDescriptor);
            propertyDescriptor.setName(property.getName());
            propertyDescriptor.setValue(property.getValue());
        }
    }

    private void addConfiguration(ConfigurableDescriptor configurableDescriptor, Xpp3Dom config, Store store) {
        Xpp3Dom[] children;
        if (null == config) {
            return;
        }
        MavenConfigurationDescriptor configDescriptor = (MavenConfigurationDescriptor)store.create(MavenConfigurationDescriptor.class);
        configurableDescriptor.setConfiguration(configDescriptor);
        for (Xpp3Dom child : children = config.getChildren()) {
            configDescriptor.getValues().add(this.getConfigChildNodes(child, store));
        }
    }

    private void addDependencies(MavenArtifactDescriptor currentArtifactDescriptor, List<Dependency> dependencies, ScannerContext scannerContext) {
        for (Dependency dependency : dependencies) {
            MavenArtifactDescriptor dependencyArtifactDescriptor = this.getMavenArtifactDescriptor(dependency, scannerContext);
            DependsOnDescriptor dependsOnDescriptor = (DependsOnDescriptor)scannerContext.getStore().create((Descriptor)currentArtifactDescriptor, DependsOnDescriptor.class, (Descriptor)dependencyArtifactDescriptor);
            dependsOnDescriptor.setOptional(dependency.isOptional());
            dependsOnDescriptor.setScope(dependency.getScope());
        }
    }

    private void addExecutionGoals(MavenPluginExecutionDescriptor executionDescriptor, PluginExecution pluginExecution, Store store) {
        List goals = pluginExecution.getGoals();
        for (String goal : goals) {
            MavenExecutionGoalDescriptor goalDescriptor = (MavenExecutionGoalDescriptor)store.create(MavenExecutionGoalDescriptor.class);
            goalDescriptor.setName(goal);
            executionDescriptor.getGoals().add(goalDescriptor);
        }
    }

    private void addLicenses(MavenPomXmlDescriptor pomDescriptor, Model model, Store store) {
        List licenses = model.getLicenses();
        for (License license : licenses) {
            MavenLicenseDescriptor licenseDescriptor = (MavenLicenseDescriptor)store.create(MavenLicenseDescriptor.class);
            licenseDescriptor.setUrl(license.getUrl());
            licenseDescriptor.setComments(license.getComments());
            licenseDescriptor.setName(license.getName());
            licenseDescriptor.setDistribution(license.getDistribution());
            pomDescriptor.getLicenses().add(licenseDescriptor);
        }
    }

    private void addManagedDependencies(BaseProfileDescriptor pomDescriptor, DependencyManagement dependencyManagement, ScannerContext scannerContext, Class<? extends BaseDependencyDescriptor> relationClass) {
        if (null == dependencyManagement) {
            return;
        }
        List dependencies = dependencyManagement.getDependencies();
        for (Dependency dependency : dependencies) {
            MavenArtifactDescriptor mavenArtifactDescriptor = this.getMavenArtifactDescriptor(dependency, scannerContext);
            BaseDependencyDescriptor managesDependencyDescriptor = (BaseDependencyDescriptor)scannerContext.getStore().create((Descriptor)pomDescriptor, relationClass, (Descriptor)mavenArtifactDescriptor);
            managesDependencyDescriptor.setOptional(dependency.isOptional());
            managesDependencyDescriptor.setScope(dependency.getScope());
        }
    }

    private void addManagedPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        PluginManagement pluginManagement = build.getPluginManagement();
        if (null == pluginManagement) {
            return;
        }
        List plugins = pluginManagement.getPlugins();
        Store store = scannerContext.getStore();
        for (Plugin plugin : plugins) {
            MavenPluginDescriptor mavenPluginDescriptor = ArtifactResolver.resolve(new PluginCoordinates(plugin), MavenPluginDescriptor.class, scannerContext);
            mavenPluginDescriptor.setInherited(plugin.isInherited());
            pomDescriptor.getManagedPlugins().add(mavenPluginDescriptor);
            this.addDependencies(mavenPluginDescriptor, plugin.getDependencies(), scannerContext);
            this.addPluginExecutions(mavenPluginDescriptor, plugin, store);
            this.addConfiguration(mavenPluginDescriptor, (Xpp3Dom)plugin.getConfiguration(), store);
        }
    }

    private void addModules(BaseProfileDescriptor pomDescriptor, List<String> modules, Store store) {
        for (String module : modules) {
            MavenModuleDescriptor moduleDescriptor = (MavenModuleDescriptor)store.create(MavenModuleDescriptor.class);
            moduleDescriptor.setName(module);
            pomDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void addParent(MavenPomXmlDescriptor pomDescriptor, Model model, ScannerContext scannerContext) {
        Parent parent = model.getParent();
        if (null != parent) {
            MavenPomDescriptor parentDescriptor = ArtifactResolver.resolve(new ParentCoordinates(parent), MavenPomDescriptor.class, scannerContext);
            pomDescriptor.setParent(parentDescriptor);
        }
    }

    private void addPluginExecutions(MavenPluginDescriptor mavenPluginDescriptor, Plugin plugin, Store store) {
        List executions = plugin.getExecutions();
        for (PluginExecution pluginExecution : executions) {
            MavenPluginExecutionDescriptor executionDescriptor = (MavenPluginExecutionDescriptor)store.create(MavenPluginExecutionDescriptor.class);
            executionDescriptor.setId(pluginExecution.getId());
            executionDescriptor.setPhase(pluginExecution.getPhase());
            executionDescriptor.setInherited(pluginExecution.isInherited());
            mavenPluginDescriptor.getExecutions().add(executionDescriptor);
            this.addExecutionGoals(executionDescriptor, pluginExecution, store);
            this.addConfiguration(executionDescriptor, (Xpp3Dom)pluginExecution.getConfiguration(), store);
        }
    }

    private void addPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        List plugins = build.getPlugins();
        Store store = scannerContext.getStore();
        for (Plugin plugin : plugins) {
            MavenPluginDescriptor mavenPluginDescriptor = ArtifactResolver.resolve(new PluginCoordinates(plugin), MavenPluginDescriptor.class, scannerContext);
            mavenPluginDescriptor.setInherited(plugin.isInherited());
            pomDescriptor.getPlugins().add(mavenPluginDescriptor);
            this.addDependencies(mavenPluginDescriptor, plugin.getDependencies(), scannerContext);
            this.addPluginExecutions(mavenPluginDescriptor, plugin, store);
            this.addConfiguration(mavenPluginDescriptor, (Xpp3Dom)plugin.getConfiguration(), store);
        }
    }

    private void addProfileDependencies(MavenProfileDescriptor profileDescriptor, List<Dependency> dependencies, ScannerContext scannerContext) {
        for (Dependency dependency : dependencies) {
            MavenArtifactDescriptor dependencyArtifactDescriptor = this.getMavenArtifactDescriptor(dependency, scannerContext);
            ProfileDependsOnDescriptor profileDependsOnDescriptor = (ProfileDependsOnDescriptor)scannerContext.getStore().create((Descriptor)profileDescriptor, ProfileDependsOnDescriptor.class, (Descriptor)dependencyArtifactDescriptor);
            profileDependsOnDescriptor.setOptional(dependency.isOptional());
            profileDependsOnDescriptor.setScope(dependency.getScope());
        }
    }

    private void addProfiles(MavenPomXmlDescriptor pomDescriptor, Model model, ScannerContext scannerContext) {
        List profiles = model.getProfiles();
        Store store = scannerContext.getStore();
        for (Profile profile : profiles) {
            MavenProfileDescriptor mavenProfileDescriptor = (MavenProfileDescriptor)store.create(MavenProfileDescriptor.class);
            pomDescriptor.getProfiles().add(mavenProfileDescriptor);
            mavenProfileDescriptor.setId(profile.getId());
            this.addProperties(mavenProfileDescriptor, profile.getProperties(), store);
            this.addModules(mavenProfileDescriptor, profile.getModules(), store);
            this.addPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addManagedPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addManagedDependencies(mavenProfileDescriptor, profile.getDependencyManagement(), scannerContext, ProfileManagesDependencyDescriptor.class);
            this.addProfileDependencies(mavenProfileDescriptor, profile.getDependencies(), scannerContext);
            this.addActivation(mavenProfileDescriptor, profile.getActivation(), store);
        }
    }

    private void addProperties(BaseProfileDescriptor pomDescriptor, Properties properties, Store store) {
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(entry.getKey().toString());
            propertyDescriptor.setValue(entry.getValue().toString());
            pomDescriptor.getProperties().add(propertyDescriptor);
        }
    }

    private MavenArtifactDescriptor getMavenArtifactDescriptor(Dependency dependency, ScannerContext scannerContext) {
        ArtifactFileDescriptor artifactDescriptor = ArtifactResolver.resolve(new ArtifactResolver.DependencyCoordinates(dependency), ArtifactFileDescriptor.class, scannerContext);
        return (MavenArtifactDescriptor)scannerContext.getStore().addDescriptorType((Descriptor)artifactDescriptor, MavenArtifactDescriptor.class);
    }

    private ValueDescriptor<?> getConfigChildNodes(Xpp3Dom node, Store store) {
        Xpp3Dom[] children = node.getChildren();
        if (children.length == 0) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(node.getName());
            propertyDescriptor.setValue(node.getValue());
            return propertyDescriptor;
        }
        ArrayValueDescriptor childDescriptor = (ArrayValueDescriptor)store.create(ArrayValueDescriptor.class);
        childDescriptor.setName(node.getName());
        for (Xpp3Dom child : children) {
            childDescriptor.getValue().add(this.getConfigChildNodes(child, store));
        }
        return childDescriptor;
    }

    public MavenPomXmlDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Model model;
        try (InputStream stream = item.createStream();){
            MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
            model = mavenXpp3Reader.read(stream);
        }
        catch (XmlPullParserException e) {
            throw new IOException("Cannot read POM descriptor.", e);
        }
        MavenPomXmlDescriptor pomDescriptor = this.createDescriptor(model, item, path, scanner);
        ScannerContext scannerContext = scanner.getContext();
        Store store = scannerContext.getStore();
        pomDescriptor.setFileName(path);
        this.addParent(pomDescriptor, model, scannerContext);
        this.addProfiles(pomDescriptor, model, scannerContext);
        this.addProperties(pomDescriptor, model.getProperties(), store);
        this.addModules(pomDescriptor, model.getModules(), store);
        this.addManagedDependencies(pomDescriptor, model.getDependencyManagement(), scannerContext, PomManagesDependencyDescriptor.class);
        this.addDependencies(pomDescriptor, model.getDependencies(), scannerContext);
        this.addManagedPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addLicenses(pomDescriptor, model, store);
        return pomDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MavenPomXmlDescriptor createDescriptor(Model model, FileResource item, String path, Scanner scanner) {
        MavenPomXmlDescriptor pomXmlDescriptor = ArtifactResolver.resolve(new ModelCoordinates(model), MavenPomXmlDescriptor.class, scanner.getContext());
        pomXmlDescriptor.setFileName(path);
        scanner.getContext().push(XmlFileDescriptor.class, (Object)pomXmlDescriptor);
        try {
            scanner.scan((Object)item, path, (Scope)XmlScope.DOCUMENT);
        }
        finally {
            scanner.getContext().pop(XmlFileDescriptor.class);
        }
        return pomXmlDescriptor;
    }

    private static final class PluginCoordinates
    implements ArtifactResolver.Coordinates {
        private Plugin plugin;

        public PluginCoordinates(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public String getGroupId() {
            return this.plugin.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.plugin.getArtifactId();
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public String getVersion() {
            return this.plugin.getVersion();
        }

        @Override
        public String getId() {
            return this.plugin.getId();
        }
    }

    private static final class ParentCoordinates
    implements ArtifactResolver.Coordinates {
        private Parent parent;

        public ParentCoordinates(Parent parent) {
            this.parent = parent;
        }

        @Override
        public String getGroupId() {
            return this.parent.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.parent.getArtifactId();
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getType() {
            return "pom";
        }

        @Override
        public String getVersion() {
            return this.parent.getVersion();
        }

        @Override
        public String getId() {
            return this.parent.getId();
        }
    }

    private static final class ModelCoordinates
    implements ArtifactResolver.Coordinates {
        private Model model;

        public ModelCoordinates(Model model) {
            this.model = model;
        }

        @Override
        public String getGroupId() {
            return this.model.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.model.getArtifactId();
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getType() {
            return this.model.getPackaging();
        }

        @Override
        public String getVersion() {
            return this.model.getVersion();
        }

        @Override
        public String getId() {
            return this.model.getId();
        }
    }
}

