/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMavenProjectScannerPlugin
extends AbstractScannerPlugin<MavenProject, MavenProjectDirectoryDescriptor> {
    public Class<? extends MavenProject> getType() {
        return MavenProject.class;
    }

    public Class<? extends MavenProjectDirectoryDescriptor> getDescriptorType() {
        return MavenProjectDirectoryDescriptor.class;
    }

    protected <T extends MavenProjectDescriptor> T resolveProject(MavenProject project, Class<T> expectedType, ScannerContext scannerContext) {
        String id;
        Store store = scannerContext.getStore();
        MavenProjectDescriptor projectDescriptor = (MavenProjectDescriptor)store.find(MavenProjectDescriptor.class, id = project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
        if (projectDescriptor == null) {
            projectDescriptor = (MavenProjectDescriptor)store.create(expectedType, id);
            projectDescriptor.setName(project.getName());
            projectDescriptor.setGroupId(project.getGroupId());
            projectDescriptor.setArtifactId(project.getArtifactId());
            projectDescriptor.setVersion(project.getVersion());
            projectDescriptor.setPackaging(project.getPackaging());
        } else if (!expectedType.isAssignableFrom(projectDescriptor.getClass())) {
            projectDescriptor = (MavenProjectDescriptor)store.migrate((Descriptor)projectDescriptor, expectedType, new Class[0]);
        }
        return (T)((MavenProjectDescriptor)expectedType.cast(projectDescriptor));
    }
}

