/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.proxy.common.property;

import com.buschmais.xo.impl.AbstractPropertyManager;
import com.buschmais.xo.impl.proxy.common.property.AbstractPropertyMethod;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.reflection.PropertyMethod;

public abstract class AbstractPrimitivePropertyGetMethod<DatastoreType, PropertyManager extends AbstractPropertyManager<DatastoreType>>
extends AbstractPropertyMethod<DatastoreType, PropertyManager, PrimitivePropertyMethodMetadata> {
    public AbstractPrimitivePropertyGetMethod(PropertyManager propertyManager, PrimitivePropertyMethodMetadata metadata) {
        super(propertyManager, metadata);
    }

    public Object invoke(DatastoreType datastoreType, Object instance, Object[] args) {
        PrimitivePropertyMethodMetadata metadata = (PrimitivePropertyMethodMetadata)this.getMetadata();
        Object propertyManager = this.getPropertyManager();
        Object value = !((AbstractPropertyManager)propertyManager).hasProperty(datastoreType, metadata) ? null : ((AbstractPropertyManager)propertyManager).getProperty(datastoreType, metadata);
        return this.convert(value, ((PropertyMethod)metadata.getAnnotatedMethod()).getType());
    }

    private Object convert(Object value, Class<?> type) {
        if (value != null) {
            if (Enum.class.isAssignableFrom(type)) {
                return Enum.valueOf(type, (String)value);
            }
            return value;
        }
        if (Boolean.TYPE.equals(type)) {
            return false;
        }
        if (Short.TYPE.equals(type)) {
            return 0;
        }
        if (Integer.TYPE.equals(type)) {
            return 0;
        }
        if (Long.TYPE.equals(type)) {
            return 0L;
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return 0.0;
        }
        if (Character.TYPE.equals(type)) {
            return 0;
        }
        if (Byte.TYPE.equals(type)) {
            return 0;
        }
        return null;
    }
}

