/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.metadata;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.impl.metadata.EntityTypeMetadataResolver;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.MethodMetadata;
import com.buschmais.xo.spi.metadata.type.DatastoreTypeMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import com.buschmais.xo.spi.reflection.AnnotatedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RelationTypeMetadataResolver<EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator> {
    private final Map<RelationDiscriminator, Set<RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator>>> relationMappings = new HashMap<RelationDiscriminator, Set<RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator>>>();
    private final Map<RelationPropertyKey, AbstractRelationPropertyMethodMetadata<RelationMetadata>> relationProperties = new HashMap<RelationPropertyKey, AbstractRelationPropertyMethodMetadata<RelationMetadata>>();

    public RelationTypeMetadataResolver(Map<Class<?>, TypeMetadata> metadataByType, EntityTypeMetadataResolver entityTypeMetadataResolver) {
        for (TypeMetadata typeMetadata : metadataByType.values()) {
            if (typeMetadata instanceof RelationTypeMetadata) {
                RelationTypeMetadata relationTypeMetadata = (RelationTypeMetadata)typeMetadata;
                Class outgoingType = relationTypeMetadata.getFromType();
                EntityTypeMetadata outgoingTypeMetadata = (EntityTypeMetadata)metadataByType.get(outgoingType);
                Set outgoingDiscriminators = entityTypeMetadataResolver.getDiscriminators(outgoingTypeMetadata);
                Class incomingType = relationTypeMetadata.getToType();
                EntityTypeMetadata incomingTypeMetadata = (EntityTypeMetadata)metadataByType.get(incomingType);
                Set incomingDiscriminators = entityTypeMetadataResolver.getDiscriminators(incomingTypeMetadata);
                RelationMapping relationMapping = new RelationMapping(outgoingDiscriminators, relationTypeMetadata, incomingDiscriminators);
                Set<RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator>> mappingSet = this.relationMappings.get(((DatastoreRelationMetadata)relationTypeMetadata.getDatastoreMetadata()).getDiscriminator());
                if (mappingSet == null) {
                    mappingSet = new HashSet<RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator>>();
                    this.relationMappings.put(((DatastoreRelationMetadata)relationTypeMetadata.getDatastoreMetadata()).getDiscriminator(), mappingSet);
                }
                mappingSet.add(relationMapping);
                continue;
            }
            if (!(typeMetadata instanceof EntityTypeMetadata)) continue;
            EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)typeMetadata;
            for (MethodMetadata methodMetadata : entityTypeMetadata.getProperties()) {
                AbstractRelationPropertyMethodMetadata propertyMethodMetadata;
                AnnotatedType relationType;
                if (!(methodMetadata instanceof AbstractRelationPropertyMethodMetadata) || (relationType = (propertyMethodMetadata = (AbstractRelationPropertyMethodMetadata)methodMetadata).getRelationshipMetadata().getAnnotatedType()) == null) continue;
                Class entityType = (Class)entityTypeMetadata.getAnnotatedType().getAnnotatedElement();
                RelationTypeMetadata relationTypeMetadata = (RelationTypeMetadata)metadataByType.get(relationType.getAnnotatedElement());
                RelationTypeMetadata.Direction direction = propertyMethodMetadata.getDirection();
                this.relationProperties.put(new RelationPropertyKey(entityType, relationTypeMetadata, direction), propertyMethodMetadata);
            }
        }
    }

    public TypeMetadataSet<RelationTypeMetadata<RelationMetadata>> getRelationTypes(Set<EntityDiscriminator> sourceDiscriminators, RelationDiscriminator discriminator, Set<EntityDiscriminator> targetDiscriminators) {
        TypeMetadataSet types = new TypeMetadataSet();
        Set<RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator>> relations = this.relationMappings.get(discriminator);
        if (relations == null) {
            throw new XOException("Cannot resolve relation from discriminator '" + discriminator + "'");
        }
        for (RelationMapping<EntityDiscriminator, RelationMetadata, RelationDiscriminator> relation : relations) {
            Set source = ((RelationMapping)relation).getSource();
            Set target = ((RelationMapping)relation).getTarget();
            if (!sourceDiscriminators.containsAll(source) || !targetDiscriminators.containsAll(target)) continue;
            types.add((DatastoreTypeMetadata)((RelationMapping)relation).getRelationType());
        }
        return types;
    }

    public AbstractRelationPropertyMethodMetadata<?> getRelationPropertyMethodMetadata(Class<?> type, RelationTypeMetadata<?> relationTypeMetadata, RelationTypeMetadata.Direction direction) {
        Class containingType = null;
        switch (direction) {
            case FROM: {
                if (!relationTypeMetadata.getFromType().isAssignableFrom(type)) break;
                containingType = relationTypeMetadata.getFromType();
                break;
            }
            case TO: {
                if (!relationTypeMetadata.getToType().isAssignableFrom(type)) break;
                containingType = relationTypeMetadata.getToType();
                break;
            }
            default: {
                throw direction.createNotSupportedException();
            }
        }
        if (containingType == null) {
            throw new XOException("Cannot resolve entity type containing a relation of type '" + relationTypeMetadata.getAnnotatedType().getName() + "'.");
        }
        RelationPropertyKey relationPropertyKey = new RelationPropertyKey(containingType, relationTypeMetadata, direction);
        AbstractRelationPropertyMethodMetadata<RelationMetadata> propertyMethodMetadata = this.relationProperties.get(relationPropertyKey);
        if (propertyMethodMetadata == null) {
            throw new XOException("Cannot resolve property in type '" + containingType.getName() + "' for relation type '" + ((Class)relationTypeMetadata.getAnnotatedType().getAnnotatedElement()).getName() + "'.");
        }
        return propertyMethodMetadata;
    }

    private static class RelationMapping<EntityDiscriminator, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator> {
        private final Set<EntityDiscriminator> source;
        private final RelationTypeMetadata<RelationMetadata> relationType;
        private final Set<EntityDiscriminator> target;

        private RelationMapping(Set<EntityDiscriminator> source, RelationTypeMetadata<RelationMetadata> relationType, Set<EntityDiscriminator> target) {
            this.source = source;
            this.relationType = relationType;
            this.target = target;
        }

        private Set<EntityDiscriminator> getSource() {
            return this.source;
        }

        private RelationTypeMetadata<RelationMetadata> getRelationType() {
            return this.relationType;
        }

        private Set<EntityDiscriminator> getTarget() {
            return this.target;
        }
    }

    private static class RelationPropertyKey {
        private final Class<?> entityType;
        private final RelationTypeMetadata<?> relationTypeMetadata;
        private final RelationTypeMetadata.Direction direction;

        private RelationPropertyKey(Class<?> entityType, RelationTypeMetadata<?> relationTypeMetadata, RelationTypeMetadata.Direction direction) {
            this.entityType = entityType;
            this.relationTypeMetadata = relationTypeMetadata;
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationPropertyKey that = (RelationPropertyKey)o;
            if (this.direction != that.direction) {
                return false;
            }
            if (!this.entityType.equals(that.entityType)) {
                return false;
            }
            return this.relationTypeMetadata.equals(that.relationTypeMetadata);
        }

        public int hashCode() {
            int result = this.entityType.hashCode();
            result = 31 * result + this.relationTypeMetadata.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }

        public String toString() {
            return "RelationPropertyKey{entityType=" + this.entityType + ", relationTypeMetadata=" + this.relationTypeMetadata + ", direction=" + this.direction + '}';
        }
    }
}

