/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.metadata;

import com.buschmais.xo.api.CompositeObject;
import com.buschmais.xo.api.Query;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.annotation.Abstract;
import com.buschmais.xo.api.annotation.Final;
import com.buschmais.xo.api.annotation.ImplementedBy;
import com.buschmais.xo.api.annotation.Repository;
import com.buschmais.xo.api.annotation.ResultOf;
import com.buschmais.xo.api.annotation.Transient;
import com.buschmais.xo.impl.MetadataProvider;
import com.buschmais.xo.impl.metadata.EntityTypeMetadataResolver;
import com.buschmais.xo.impl.metadata.MetadataProviderImpl$$Lambda$1;
import com.buschmais.xo.impl.metadata.RelationTypeMetadataResolver;
import com.buschmais.xo.spi.annotation.EntityDefinition;
import com.buschmais.xo.spi.annotation.IndexDefinition;
import com.buschmais.xo.spi.annotation.QueryDefinition;
import com.buschmais.xo.spi.annotation.RelationDefinition;
import com.buschmais.xo.spi.datastore.Datastore;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreMetadataFactory;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.EntityCollectionPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.EntityReferencePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.MethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.RelationCollectionPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.RelationReferencePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.ResultOfMethodMetadata;
import com.buschmais.xo.spi.metadata.method.TransientPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.UnsupportedOperationMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RepositoryTypeMetadata;
import com.buschmais.xo.spi.metadata.type.SimpleTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import com.buschmais.xo.spi.reflection.AbstractAnnotatedElement;
import com.buschmais.xo.spi.reflection.AnnotatedElement;
import com.buschmais.xo.spi.reflection.AnnotatedMethod;
import com.buschmais.xo.spi.reflection.AnnotatedType;
import com.buschmais.xo.spi.reflection.BeanMethodProvider;
import com.buschmais.xo.spi.reflection.DependencyResolver;
import com.buschmais.xo.spi.reflection.PropertyMethod;
import com.buschmais.xo.spi.reflection.UserMethod;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProviderImpl<EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator>
implements MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityTypeMetadata.class);
    private final DatastoreMetadataFactory<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataFactory;
    private final EntityTypeMetadataResolver<EntityMetadata, EntityDiscriminator> entityTypeMetadataResolver;
    private final RelationTypeMetadataResolver<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> relationTypeMetadataResolver;
    private final Map<Class<?>, Collection<AnnotatedMethod>> annotatedMethods;
    private final Map<Class<?>, TypeMetadata> metadataByType = new LinkedHashMap();
    private final Cache<java.lang.reflect.AnnotatedElement, Optional<Annotation>> queryTypes = CacheBuilder.newBuilder().build();

    public MetadataProviderImpl(Collection<Class<?>> types, Datastore<?, EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> datastore) {
        this.metadataFactory = datastore.getMetadataFactory();
        DependencyResolver.DependencyProvider classDependencyProvider = MetadataProviderImpl$$Lambda$1.lambdaFactory$();
        List allClasses = DependencyResolver.newInstance(types, (DependencyResolver.DependencyProvider)classDependencyProvider).resolve();
        LOGGER.debug("Processing types {}", (Object)allClasses);
        this.annotatedMethods = new HashMap();
        for (Class currentClass : allClasses) {
            if (!currentClass.isInterface()) {
                throw new XOException("Type " + currentClass.getName() + " is not an interface.");
            }
            this.annotatedMethods.put(currentClass, BeanMethodProvider.newInstance((Class)currentClass).getMethods());
        }
        for (Class currentClass : allClasses) {
            this.getOrCreateTypeMetadata(currentClass);
        }
        this.entityTypeMetadataResolver = new EntityTypeMetadataResolver(this.metadataByType);
        this.relationTypeMetadataResolver = new RelationTypeMetadataResolver(this.metadataByType, this.entityTypeMetadataResolver);
        this.metadataByType.put(CompositeObject.class, (TypeMetadata)new SimpleTypeMetadata(new AnnotatedType(CompositeObject.class), Collections.emptyList(), Collections.emptyList(), null));
    }

    @Override
    public TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> getTypes(Set<EntityDiscriminator> entityDiscriminators) {
        return this.entityTypeMetadataResolver.getTypes(entityDiscriminators);
    }

    @Override
    public TypeMetadataSet<RelationTypeMetadata<RelationMetadata>> getRelationTypes(Set<EntityDiscriminator> sourceDiscriminators, RelationDiscriminator discriminator, Set<EntityDiscriminator> targetDiscriminators) {
        return this.relationTypeMetadataResolver.getRelationTypes(sourceDiscriminators, discriminator, targetDiscriminators);
    }

    @Override
    public Set<EntityDiscriminator> getEntityDiscriminators(TypeMetadataSet<EntityTypeMetadata<EntityMetadata>> types) {
        HashSet<EntityDiscriminator> entityDiscriminators = new HashSet<EntityDiscriminator>();
        for (EntityTypeMetadata entityTypeMetadata : types) {
            Set<EntityDiscriminator> discriminatorsOfType = this.entityTypeMetadataResolver.getDiscriminators(entityTypeMetadata);
            entityDiscriminators.addAll(discriminatorsOfType);
        }
        return entityDiscriminators;
    }

    @Override
    public Map<Class<?>, TypeMetadata> getRegisteredMetadata() {
        return Collections.unmodifiableMap(this.metadataByType);
    }

    @Override
    public EntityTypeMetadata<EntityMetadata> getEntityMetadata(Class<?> entityType) {
        return this.getMetadata(entityType, EntityTypeMetadata.class);
    }

    @Override
    public RelationTypeMetadata<RelationMetadata> getRelationMetadata(Class<?> relationType) {
        return this.getMetadata(relationType, RelationTypeMetadata.class);
    }

    @Override
    public RelationTypeMetadata.Direction getRelationDirection(Set<Class<?>> sourceTypes, RelationTypeMetadata<RelationMetadata> relationMetadata, Set<Class<?>> targetTypes) {
        if (sourceTypes.contains(relationMetadata.getFromType()) && targetTypes.contains(relationMetadata.getToType())) {
            return RelationTypeMetadata.Direction.FROM;
        }
        if (targetTypes.contains(relationMetadata.getFromType()) && sourceTypes.contains(relationMetadata.getToType())) {
            return RelationTypeMetadata.Direction.TO;
        }
        throw new XOException("The relation '" + relationMetadata + "' is not defined for the instances.");
    }

    @Override
    public RepositoryTypeMetadata getRepositoryMetadata(Class<?> repositoryType) {
        return this.getMetadata(repositoryType, RepositoryTypeMetadata.class);
    }

    @Override
    public <R> AbstractRelationPropertyMethodMetadata<?> getPropertyMetadata(Class<?> entityType, Class<R> relationType, RelationTypeMetadata.Direction direction) {
        return this.relationTypeMetadataResolver.getRelationPropertyMethodMetadata(entityType, this.getRelationMetadata(relationType), direction);
    }

    private TypeMetadata getOrCreateTypeMetadata(Class<?> type) {
        AnnotatedType annotatedType = new AnnotatedType(type);
        TypeMetadata typeMetadata = this.metadataByType.get(annotatedType.getAnnotatedElement());
        if (typeMetadata == null) {
            typeMetadata = this.createTypeMetadata(annotatedType);
            LOGGER.debug("Registering class {}", (Object)annotatedType.getName());
            this.metadataByType.put((Class<?>)annotatedType.getAnnotatedElement(), typeMetadata);
        }
        return typeMetadata;
    }

    private TypeMetadata createTypeMetadata(AnnotatedType annotatedType) {
        RepositoryTypeMetadata metadata;
        Class currentClass = (Class)annotatedType.getAnnotatedElement();
        Collection<AnnotatedMethod> annotatedMethods = this.annotatedMethods.get(currentClass);
        if (annotatedMethods == null) {
            throw new XOException("XO unit does not declare '" + currentClass.getName() + "'.");
        }
        Collection<MethodMetadata<?, ?>> methodMetadataOfType = this.getMethodMetadataOfType(annotatedType, annotatedMethods);
        List<TypeMetadata> superTypes = this.getSuperTypeMetadata(annotatedType);
        if (this.isEntityType(annotatedType)) {
            metadata = this.createEntityTypeMetadata(annotatedType, superTypes, methodMetadataOfType);
        } else if (this.isRelationType(annotatedType)) {
            metadata = this.createRelationTypeMetadata(annotatedType, superTypes, methodMetadataOfType);
        } else if (annotatedType.isAnnotationPresent(Repository.class)) {
            metadata = this.createRepositoryTypeMetadata(annotatedType, superTypes, methodMetadataOfType);
        } else {
            IndexedPropertyMethodMetadata<?> indexedProperty = this.getIndexedPropertyMethodMetadata(methodMetadataOfType);
            metadata = new SimpleTypeMetadata(annotatedType, superTypes, methodMetadataOfType, indexedProperty);
        }
        return metadata;
    }

    private boolean isEntityType(AnnotatedType annotatedType) {
        return this.isOfDefinitionType(annotatedType, EntityDefinition.class);
    }

    private boolean isRelationType(AnnotatedType annotatedType) {
        return this.isOfDefinitionType(annotatedType, RelationDefinition.class);
    }

    private boolean isOfDefinitionType(AnnotatedType annotatedType, Class<? extends Annotation> definitionType) {
        Annotation definition = annotatedType.getByMetaAnnotation(definitionType);
        if (definition != null) {
            return true;
        }
        for (Class<?> superType : ((Class)annotatedType.getAnnotatedElement()).getInterfaces()) {
            if (!this.isOfDefinitionType(new AnnotatedType(superType), definitionType)) continue;
            return true;
        }
        return false;
    }

    private EntityTypeMetadata<EntityMetadata> createEntityTypeMetadata(AnnotatedType annotatedType, List<TypeMetadata> superTypes, Collection<MethodMetadata<?, ?>> methodMetadataOfType) {
        IndexedPropertyMethodMetadata<?> indexedProperty = this.getIndexedPropertyMethodMetadata(methodMetadataOfType);
        DatastoreEntityMetadata datastoreEntityMetadata = this.metadataFactory.createEntityMetadata(annotatedType, this.metadataByType);
        boolean abstractType = annotatedType.isAnnotationPresent(Abstract.class);
        boolean finalType = annotatedType.isAnnotationPresent(Final.class);
        return new EntityTypeMetadata(annotatedType, superTypes, methodMetadataOfType, abstractType, finalType, indexedProperty, datastoreEntityMetadata);
    }

    private RelationTypeMetadata<RelationMetadata> createRelationTypeMetadata(AnnotatedType annotatedType, List<TypeMetadata> superTypes, Collection<MethodMetadata<?, ?>> methodMetadataOfType) {
        Class fromType = null;
        Class toType = null;
        Collection current = methodMetadataOfType;
        LinkedList<TypeMetadata> queue = new LinkedList<TypeMetadata>(superTypes);
        do {
            block5: for (MethodMetadata<?, ?> methodMetadata : current) {
                if (!(methodMetadata instanceof EntityReferencePropertyMethodMetadata)) continue;
                EntityReferencePropertyMethodMetadata propertyMethodMetadata = (EntityReferencePropertyMethodMetadata)methodMetadata;
                Class type = ((PropertyMethod)propertyMethodMetadata.getAnnotatedMethod()).getType();
                switch (propertyMethodMetadata.getDirection()) {
                    case FROM: {
                        fromType = type;
                        continue block5;
                    }
                    case TO: {
                        toType = type;
                        continue block5;
                    }
                }
                throw propertyMethodMetadata.getDirection().createNotSupportedException();
            }
            TypeMetadata superType = (TypeMetadata)queue.poll();
            if (superType != null) {
                queue.addAll(superType.getSuperTypes());
                current = superType.getProperties();
                continue;
            }
            current = null;
        } while (current != null && fromType == null && toType == null);
        if (fromType == null || toType == null) {
            throw new XOException("Relation type '" + ((Class)annotatedType.getAnnotatedElement()).getName() + "' does not define target entity properties for both directions.");
        }
        DatastoreRelationMetadata relationMetadata = this.metadataFactory.createRelationMetadata((AnnotatedElement)annotatedType, this.metadataByType);
        RelationTypeMetadata relationTypeMetadata = new RelationTypeMetadata(annotatedType, superTypes, methodMetadataOfType, fromType, toType, (Object)relationMetadata);
        this.metadataByType.put((Class<?>)annotatedType.getAnnotatedElement(), (TypeMetadata)relationTypeMetadata);
        return relationTypeMetadata;
    }

    private RepositoryTypeMetadata createRepositoryTypeMetadata(AnnotatedType annotatedType, List<TypeMetadata> superTypes, Collection<MethodMetadata<?, ?>> methodMetadataOfType) {
        RepositoryTypeMetadata repositoryTypeMetadata = new RepositoryTypeMetadata(annotatedType, superTypes, methodMetadataOfType);
        this.metadataByType.put((Class<?>)annotatedType.getAnnotatedElement(), (TypeMetadata)repositoryTypeMetadata);
        return repositoryTypeMetadata;
    }

    private List<TypeMetadata> getSuperTypeMetadata(AnnotatedType annotatedType) {
        ArrayList<TypeMetadata> superTypes = new ArrayList<TypeMetadata>();
        for (Class<?> i : ((Class)annotatedType.getAnnotatedElement()).getInterfaces()) {
            superTypes.add(this.getOrCreateTypeMetadata(i));
        }
        return superTypes;
    }

    private IndexedPropertyMethodMetadata<?> getIndexedPropertyMethodMetadata(Collection<MethodMetadata<?, ?>> methodMetadataOfType) {
        for (MethodMetadata<?, ?> methodMetadata : methodMetadataOfType) {
            AnnotatedMethod annotatedMethod = methodMetadata.getAnnotatedMethod();
            Annotation indexedAnnotation = annotatedMethod.getByMetaAnnotation(IndexDefinition.class);
            if (indexedAnnotation == null) continue;
            if (!(methodMetadata instanceof PrimitivePropertyMethodMetadata)) {
                throw new XOException("Only primitive properties are allowed to be used for indexing.");
            }
            return new IndexedPropertyMethodMetadata((PropertyMethod)annotatedMethod, (PrimitivePropertyMethodMetadata)methodMetadata, this.metadataFactory.createIndexedPropertyMetadata((PropertyMethod)annotatedMethod));
        }
        return null;
    }

    private Collection<MethodMetadata<?, ?>> getMethodMetadataOfType(AnnotatedType annotatedType, Collection<AnnotatedMethod> annotatedMethods) {
        ArrayList methodMetadataOfType = new ArrayList();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            PropertyMethod propertyMethod;
            Transient transientAnnotation;
            ImplementedBy implementedBy = (ImplementedBy)annotatedMethod.getAnnotation(ImplementedBy.class);
            ResultOf resultOf = (ResultOf)annotatedMethod.getAnnotation(ResultOf.class);
            Object methodMetadata = implementedBy != null ? new MethodMetadata(annotatedMethod, implementedBy.value(), this.metadataFactory.createImplementedByMetadata(annotatedMethod)) : (resultOf != null ? this.createResultOfMetadata(annotatedMethod, resultOf) : (annotatedMethod instanceof PropertyMethod ? ((transientAnnotation = (Transient)(propertyMethod = (PropertyMethod)annotatedMethod).getAnnotationOfProperty(Transient.class)) != null ? new TransientPropertyMethodMetadata(propertyMethod) : this.createPropertyMethodMetadata(annotatedType, propertyMethod)) : new UnsupportedOperationMethodMetadata((UserMethod)annotatedMethod)));
            methodMetadataOfType.add((MethodMetadata<?, ?>)methodMetadata);
        }
        return methodMetadataOfType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MethodMetadata<?, ?> createPropertyMethodMetadata(AnnotatedType annotatedType, PropertyMethod propertyMethod) {
        Class propertyType = propertyMethod.getType();
        if (Collection.class.isAssignableFrom(propertyType)) {
            Class elementType;
            Type genericType = propertyMethod.getGenericType();
            ParameterizedType type = (ParameterizedType)genericType;
            Type typeArgument = type.getActualTypeArguments()[0];
            if (typeArgument instanceof Class) {
                elementType = (Class)typeArgument;
            } else {
                if (!(typeArgument instanceof ParameterizedType)) throw new XOException("Cannot determine argument type of collection property " + ((Method)propertyMethod.getAnnotatedElement()).toGenericString());
                ParameterizedType parameterizedTypeArgument = (ParameterizedType)typeArgument;
                elementType = (Class)parameterizedTypeArgument.getRawType();
            }
            AnnotatedType annotatedTypeArgument = new AnnotatedType(elementType);
            if (this.isEntityType(annotatedTypeArgument)) {
                RelationTypeMetadata.Direction relationDirection = this.getRelationDirection(propertyMethod, RelationTypeMetadata.Direction.FROM);
                AnnotatedElement<?> relationElement = this.getRelationDefinitionElement(propertyMethod);
                RelationTypeMetadata relationshipType = new RelationTypeMetadata((Object)this.metadataFactory.createRelationMetadata(relationElement, this.metadataByType));
                return new EntityCollectionPropertyMethodMetadata(propertyMethod, relationshipType, relationDirection, this.metadataFactory.createCollectionPropertyMetadata(propertyMethod));
            }
            if (!this.isRelationType(annotatedTypeArgument)) throw new XOException("Unsupported type argument '" + elementType.getName() + "' for collection property: " + propertyType.getName());
            TypeMetadata relationTypeMetadata = this.getOrCreateTypeMetadata(elementType);
            RelationTypeMetadata relationMetadata = (RelationTypeMetadata)relationTypeMetadata;
            RelationTypeMetadata.Direction relationDirection = this.getRelationDirection(annotatedType, propertyMethod, relationTypeMetadata, relationMetadata);
            return new RelationCollectionPropertyMethodMetadata(propertyMethod, relationMetadata, relationDirection, this.metadataFactory.createCollectionPropertyMetadata(propertyMethod));
        }
        if (!this.annotatedMethods.containsKey(propertyType)) return new PrimitivePropertyMethodMetadata(propertyMethod, this.metadataFactory.createPropertyMetadata(propertyMethod));
        AnnotatedType referencedType = new AnnotatedType(propertyType);
        if (this.isEntityType(referencedType)) {
            RelationTypeMetadata.Direction relationDirection = this.getRelationDirection(propertyMethod, RelationTypeMetadata.Direction.FROM);
            AnnotatedElement<?> relationElement = this.getRelationDefinitionElement(propertyMethod);
            RelationTypeMetadata relationMetadata = new RelationTypeMetadata((Object)this.metadataFactory.createRelationMetadata(relationElement, this.metadataByType));
            return new EntityReferencePropertyMethodMetadata(propertyMethod, relationMetadata, relationDirection, this.metadataFactory.createReferencePropertyMetadata(propertyMethod));
        }
        if (!this.isRelationType(referencedType)) throw new XOException("Unsupported type for reference property: " + propertyType.getName());
        TypeMetadata relationTypeMetadata = this.getOrCreateTypeMetadata(propertyType);
        RelationTypeMetadata relationMetadata = (RelationTypeMetadata)relationTypeMetadata;
        RelationTypeMetadata.Direction relationDirection = this.getRelationDirection(annotatedType, propertyMethod, relationTypeMetadata, relationMetadata);
        return new RelationReferencePropertyMethodMetadata(propertyMethod, relationMetadata, relationDirection, this.metadataFactory.createReferencePropertyMetadata(propertyMethod));
    }

    private RelationTypeMetadata.Direction getRelationDirection(PropertyMethod propertyMethod, RelationTypeMetadata.Direction defaultDirection) {
        Annotation fromAnnotation = propertyMethod.getByMetaAnnotationOfProperty(RelationDefinition.FromDefinition.class);
        Annotation toAnnotation = propertyMethod.getByMetaAnnotationOfProperty(RelationDefinition.ToDefinition.class);
        if (fromAnnotation != null && toAnnotation != null) {
            throw new XOException("The relation property '" + propertyMethod.getName() + "' must not specifiy both directions.'");
        }
        RelationTypeMetadata.Direction direction = null;
        if (fromAnnotation != null) {
            direction = RelationTypeMetadata.Direction.FROM;
        }
        if (toAnnotation != null) {
            direction = RelationTypeMetadata.Direction.TO;
        }
        return direction != null ? direction : defaultDirection;
    }

    private RelationTypeMetadata.Direction getRelationDirection(AnnotatedType annotatedEntityType, PropertyMethod propertyMethod, TypeMetadata propertyTypeMetadata, RelationTypeMetadata<RelationMetadata> relationMetadata) {
        RelationTypeMetadata.Direction relationDirection = this.getRelationDirection(propertyMethod, null);
        if (relationDirection == null) {
            Class toType;
            Class fromType = relationMetadata.getFromType();
            if (fromType.equals(toType = relationMetadata.getToType())) {
                throw new XOException("Direction of property '" + ((Method)propertyMethod.getAnnotatedElement()).toGenericString() + "' is ambiguous and must be specified.");
            }
            if (((Class)annotatedEntityType.getAnnotatedElement()).equals(fromType)) {
                relationDirection = RelationTypeMetadata.Direction.FROM;
            } else if (((Class)annotatedEntityType.getAnnotatedElement()).equals(toType)) {
                relationDirection = RelationTypeMetadata.Direction.TO;
            } else {
                throw new XOException("Cannot determine relation direction for type '" + propertyTypeMetadata.getAnnotatedType().getName() + "'");
            }
        }
        return relationDirection;
    }

    private AnnotatedElement<?> getRelationDefinitionElement(PropertyMethod propertyMethod) {
        if (propertyMethod.getByMetaAnnotationOfProperty(RelationDefinition.class) != null) {
            return propertyMethod;
        }
        Annotation[] declaredAnnotations = propertyMethod.getAnnotationsOfProperty();
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            AnnotatedType annotationTypeElement = new AnnotatedType(declaredAnnotations[i].annotationType());
            if (annotationTypeElement.getByMetaAnnotation(RelationDefinition.class) == null) continue;
            return annotationTypeElement;
        }
        return propertyMethod;
    }

    private MethodMetadata<?, ?> createResultOfMetadata(AnnotatedMethod annotatedMethod, ResultOf resultOf) {
        Class returnType;
        Method method = (Method)annotatedMethod.getAnnotatedElement();
        Class methodReturnType = method.getReturnType();
        if (Query.Result.class.isAssignableFrom(methodReturnType)) {
            Type genericReturnType = method.getGenericReturnType();
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            returnType = (Class)parameterizedType.getActualTypeArguments()[0];
        } else {
            returnType = methodReturnType;
        }
        java.lang.reflect.AnnotatedElement query = resultOf.query();
        if (Object.class.equals((Object)query)) {
            query = annotatedMethod.getByMetaAnnotation(QueryDefinition.class) != null ? annotatedMethod.getAnnotatedElement() : returnType;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<ResultOf.Parameter> parameters = new ArrayList<ResultOf.Parameter>();
        for (Annotation[] parameterAnnotation : parameterAnnotations) {
            ResultOf.Parameter parameter = null;
            for (Annotation annotation : parameterAnnotation) {
                if (!ResultOf.Parameter.class.equals(annotation.annotationType())) continue;
                parameter = (ResultOf.Parameter)annotation;
            }
            if (parameter == null) {
                throw new XOException("Cannot determine parameter names for '" + method.getName() + "', all parameters must be annotated with '" + ResultOf.Parameter.class.getName() + "'.");
            }
            parameters.add(parameter);
        }
        boolean singleResult = !Iterable.class.isAssignableFrom(methodReturnType);
        return new ResultOfMethodMetadata(annotatedMethod, query, returnType, resultOf.usingThisAs(), parameters, singleResult);
    }

    private <T extends TypeMetadata> T getMetadata(Class<?> type, Class<T> metadataType) {
        TypeMetadata typeMetadata = this.metadataByType.get(type);
        if (typeMetadata == null) {
            throw new XOException("Cannot resolve metadata for type " + type.getName() + ".");
        }
        if (!metadataType.isAssignableFrom(typeMetadata.getClass())) {
            throw new XOException("Expected metadata of type '" + metadataType.getName() + "' but got '" + typeMetadata.getClass() + "' for type '" + type + "'");
        }
        return (T)((TypeMetadata)metadataType.cast(typeMetadata));
    }

    @Override
    public <QL extends Annotation> QL getQuery(java.lang.reflect.AnnotatedElement annotatedElement) {
        Optional cachedOptional = (Optional)this.queryTypes.getIfPresent((Object)annotatedElement);
        if (cachedOptional == null) {
            AnnotatedQueryElement element = new AnnotatedQueryElement(annotatedElement);
            Annotation annotation = element.getByMetaAnnotation(QueryDefinition.class);
            cachedOptional = Optional.fromNullable((Object)annotation);
            this.queryTypes.put((Object)annotatedElement, (Object)cachedOptional);
        }
        return (QL)(cachedOptional.isPresent() ? (Annotation)cachedOptional.get() : null);
    }

    private static /* synthetic */ Set lambda$new$0(Class dependent) {
        return new HashSet(Arrays.asList(dependent.getInterfaces()));
    }

    static /* bridge */ /* synthetic */ Set access$lambda$0(Class clazz) {
        return MetadataProviderImpl.lambda$new$0(clazz);
    }

    private static class AnnotatedQueryElement
    extends AbstractAnnotatedElement<java.lang.reflect.AnnotatedElement> {
        public AnnotatedQueryElement(java.lang.reflect.AnnotatedElement typeExpression) {
            super(typeExpression);
        }

        public String getName() {
            return this.toString();
        }
    }
}

