/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.impl.AbstractResultIterable;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.transaction.TransactionalResultIterator;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RepositoryTypeMetadata;
import com.buschmais.xo.spi.session.InstanceManager;
import com.buschmais.xo.spi.session.XOSession;

public class XOSessionImpl<EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationId, Relation, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator, PropertyMetadata>
implements XOSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> {
    private SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> sessionContext;

    public XOSessionImpl(SessionContext<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> sessionContext) {
        this.sessionContext = sessionContext;
    }

    public <T, D> D toDatastore(T value) {
        return (D)value;
    }

    public <D, T> T fromDatastore(D value) {
        InstanceManager<?, D> instanceManager = this.getInstanceManager(value);
        if (instanceManager != null) {
            return (T)instanceManager.readInstance(value);
        }
        return (T)value;
    }

    public <T> EntityTypeMetadata<EntityMetadata> getEntityMetadata(Class<T> type) {
        return this.sessionContext.getMetadataProvider().getEntityMetadata(type);
    }

    public <T> RelationTypeMetadata<RelationMetadata> getRelationMetadata(Class<T> type) {
        return this.sessionContext.getMetadataProvider().getRelationMetadata(type);
    }

    public <R> RepositoryTypeMetadata getRepositoryMetadata(Class<R> type) {
        return this.sessionContext.getMetadataProvider().getRepositoryMetadata(type);
    }

    public <D> InstanceManager<?, D> getInstanceManager(D datastoreType) {
        if (this.sessionContext.getEntityInstanceManager().isDatastoreType(datastoreType)) {
            return this.sessionContext.getEntityInstanceManager();
        }
        if (this.sessionContext.getRelationInstanceManager().isDatastoreType(datastoreType)) {
            return this.sessionContext.getRelationInstanceManager();
        }
        return null;
    }

    public <D, T> ResultIterable<T> toResult(final ResultIterator<D> iterator) {
        ResultIterator resultIterator = new ResultIterator<T>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public T next() {
                Object datastoreValue = iterator.next();
                return XOSessionImpl.this.fromDatastore(datastoreValue);
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot remove instance.");
            }

            public void close() {
                iterator.close();
            }
        };
        XOTransaction xoTransaction = this.sessionContext.getXOTransaction();
        Object transactionalIterator = xoTransaction != null ? new TransactionalResultIterator(resultIterator, xoTransaction) : resultIterator;
        return (ResultIterable)this.sessionContext.getInterceptorFactory().addInterceptor((Object)new AbstractResultIterable<T>((ResultIterator)transactionalIterator){
            final /* synthetic */ ResultIterator val$transactionalIterator;
            {
                this.val$transactionalIterator = resultIterator;
            }

            public ResultIterator<T> iterator() {
                return this.val$transactionalIterator;
            }
        }, new Class[]{ResultIterable.class});
    }
}

