/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.AbstractPropertyManager;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.spi.datastore.DatastorePropertyManager;
import com.buschmais.xo.spi.datastore.DatastoreRelationManager;
import com.buschmais.xo.spi.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.EntityCollectionPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.EntityReferencePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.RelationCollectionPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.RelationReferencePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class EntityPropertyManager<Entity, Relation, PropertyMetadata>
extends AbstractPropertyManager<Entity> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, PropertyMetadata> sessionContext;

    public EntityPropertyManager(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, PropertyMetadata> sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    protected DatastorePropertyManager<Entity, ?> getDatastorePropertyManager() {
        return this.sessionContext.getDatastoreSession().getDatastoreEntityManager();
    }

    @Override
    protected AbstractInstanceManager<?, Entity> getInstanceManager() {
        return this.sessionContext.getEntityInstanceManager();
    }

    public <T> T createEntityReference(Entity sourceEntity, AbstractRelationPropertyMethodMetadata<?> metadata, Object target) {
        AbstractInstanceManager<?, Entity> instanceManager = this.sessionContext.getEntityInstanceManager();
        Entity targetEntity = target != null ? (Entity)instanceManager.getDatastoreType(target) : null;
        Relation relation = this.createRelation(sourceEntity, metadata, targetEntity, null, Collections.emptyMap());
        return relation != null ? (T)instanceManager.updateInstance(this.getReferencedEntity(relation, metadata.getDirection())) : null;
    }

    public <T> T createRelationReference(Entity sourceEntity, AbstractRelationPropertyMethodMetadata<?> fromProperty, Object target, AbstractRelationPropertyMethodMetadata<?> toProperty, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        AbstractInstanceManager<?, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        if (target != null) {
            Entity targetEntity = entityInstanceManager.getDatastoreType(target);
            Relation relation = this.createRelation(sourceEntity, fromProperty, targetEntity, toProperty, example);
            entityInstanceManager.updateInstance(targetEntity);
            return this.sessionContext.getRelationInstanceManager().createInstance(relation);
        }
        return null;
    }

    public Object getEntityReference(Entity entity, EntityReferencePropertyMethodMetadata metadata) {
        DatastoreRelationManager relationManager = this.sessionContext.getDatastoreSession().getDatastoreRelationManager();
        if (relationManager.hasSingleRelation(entity, metadata.getRelationshipMetadata(), metadata.getDirection())) {
            Object singleRelation = relationManager.getSingleRelation(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
            Entity target = this.getReferencedEntity(singleRelation, metadata.getDirection());
            return this.sessionContext.getEntityInstanceManager().readInstance(target);
        }
        return null;
    }

    public Iterator<Entity> getEntityCollection(Entity entity, final EntityCollectionPropertyMethodMetadata<?> metadata) {
        Iterable relations = this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelations(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
        final Iterator iterator = relations.iterator();
        return new Iterator<Entity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Entity next() {
                Object next = iterator.next();
                return EntityPropertyManager.this.getReferencedEntity(next, metadata.getDirection());
            }

            @Override
            public void remove() {
            }
        };
    }

    public Object getRelationReference(Entity entity, RelationReferencePropertyMethodMetadata<?> metadata) {
        DatastoreRelationManager relationManager = this.sessionContext.getDatastoreSession().getDatastoreRelationManager();
        if (relationManager.hasSingleRelation(entity, metadata.getRelationshipMetadata(), metadata.getDirection())) {
            Object singleRelation = relationManager.getSingleRelation(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
            return this.sessionContext.getRelationInstanceManager().readInstance(singleRelation);
        }
        return null;
    }

    public Iterator<Relation> getRelationCollection(Entity entity, RelationCollectionPropertyMethodMetadata<?> metadata) {
        Iterable relations = this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelations(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
        return relations.iterator();
    }

    public void removeEntityReferences(Entity entity, EntityCollectionPropertyMethodMetadata metadata) {
        Iterable relations = this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelations(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
        for (Object relation : relations) {
            this.removeRelation(entity, (Relation)relation, (AbstractRelationPropertyMethodMetadata<?>)metadata);
        }
    }

    public boolean removeEntityReference(Entity entity, EntityCollectionPropertyMethodMetadata<?> metadata, Object target) {
        Iterable relations = this.sessionContext.getDatastoreSession().getDatastoreRelationManager().getRelations(entity, metadata.getRelationshipMetadata(), metadata.getDirection());
        Entity targetEntity = this.sessionContext.getEntityInstanceManager().getDatastoreType(target);
        for (Object relation : relations) {
            Entity referencedEntity = this.getReferencedEntity(relation, metadata.getDirection());
            if (!referencedEntity.equals(targetEntity)) continue;
            this.removeRelation(entity, (Relation)relation, (AbstractRelationPropertyMethodMetadata<?>)metadata);
            return true;
        }
        return false;
    }

    private void removeRelation(Entity source, Relation relation, AbstractRelationPropertyMethodMetadata<?> metadata) {
        AbstractInstanceManager<?, Entity> entityInstanceManager = this.sessionContext.getEntityInstanceManager();
        entityInstanceManager.updateInstance(source);
        entityInstanceManager.updateInstance(this.getReferencedEntity(relation, metadata.getDirection()));
        this.sessionContext.getDatastoreSession().getDatastoreRelationManager().deleteRelation(relation);
        AbstractInstanceManager<?, Relation> relationInstanceManager = this.sessionContext.getRelationInstanceManager();
        if (metadata.getRelationshipMetadata().getAnnotatedType() != null) {
            Object instance = relationInstanceManager.readInstance(relation);
            relationInstanceManager.removeInstance(instance);
            relationInstanceManager.closeInstance(instance);
        }
    }

    private Entity getReferencedEntity(Relation relation, RelationTypeMetadata.Direction direction) {
        DatastoreRelationManager relationManager = this.sessionContext.getDatastoreSession().getDatastoreRelationManager();
        switch (direction) {
            case FROM: {
                return (Entity)relationManager.getTo(relation);
            }
            case TO: {
                return (Entity)relationManager.getFrom(relation);
            }
        }
        throw new XOException("Unsupported direction: " + direction);
    }

    private Relation createRelation(Entity sourceEntity, AbstractRelationPropertyMethodMetadata<?> fromProperty, Entity targetEntity, AbstractRelationPropertyMethodMetadata<?> toProperty, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        Relation relation;
        if (fromProperty instanceof EntityReferencePropertyMethodMetadata || fromProperty instanceof RelationReferencePropertyMethodMetadata) {
            relation = this.createSingleReference(sourceEntity, fromProperty, targetEntity, example);
        } else if (toProperty instanceof EntityReferencePropertyMethodMetadata || toProperty instanceof RelationReferencePropertyMethodMetadata) {
            relation = this.createSingleReference(targetEntity, toProperty, sourceEntity, example);
        } else if (fromProperty instanceof EntityCollectionPropertyMethodMetadata || fromProperty instanceof RelationCollectionPropertyMethodMetadata) {
            relation = this.createReference(sourceEntity, fromProperty.getRelationshipMetadata(), fromProperty.getDirection(), targetEntity, example);
        } else {
            throw new XOException("Unsupported relation type " + fromProperty.getClass().getName());
        }
        return relation;
    }

    private Relation createSingleReference(Entity sourceEntity, AbstractRelationPropertyMethodMetadata<?> metadata, Entity targetEntity, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        DatastoreRelationManager relationManager = this.sessionContext.getDatastoreSession().getDatastoreRelationManager();
        if (relationManager.hasSingleRelation(sourceEntity, metadata.getRelationshipMetadata(), metadata.getDirection())) {
            Object relation = relationManager.getSingleRelation(sourceEntity, metadata.getRelationshipMetadata(), metadata.getDirection());
            this.removeRelation(sourceEntity, relation, metadata);
        }
        return (Relation)(targetEntity != null ? relationManager.createRelation(sourceEntity, metadata.getRelationshipMetadata(), metadata.getDirection(), targetEntity, example) : null);
    }

    private Relation createReference(Entity sourceEntity, RelationTypeMetadata metadata, RelationTypeMetadata.Direction direction, Entity targetEntity, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        return (Relation)this.sessionContext.getDatastoreSession().getDatastoreRelationManager().createRelation(sourceEntity, metadata, direction, targetEntity, example);
    }
}

