/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ReportPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.AbstractPluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ReportType;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportPluginRepositoryImpl
extends AbstractPluginRepository
implements ReportPluginRepository {
    private final List<ReportPlugin> reportPlugins;

    public ReportPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader, Map<String, Object> properties) throws PluginRepositoryException {
        super(pluginConfigurationReader);
        List<JqassistantPlugin> plugins = pluginConfigurationReader.getPlugins();
        this.reportPlugins = this.getReportPlugins(plugins, properties);
    }

    @Override
    public List<ReportPlugin> getReportPlugins() {
        return this.reportPlugins;
    }

    private List<ReportPlugin> getReportPlugins(List<JqassistantPlugin> plugins, Map<String, Object> properties) throws PluginRepositoryException {
        ArrayList<ReportPlugin> reportPlugins = new ArrayList<ReportPlugin>();
        for (JqassistantPlugin plugin : plugins) {
            ReportType reportType = plugin.getReport();
            if (reportType == null) continue;
            for (String reportPluginName : reportType.getClazz()) {
                ReportPlugin reportPlugin = (ReportPlugin)this.createInstance(reportPluginName);
                if (reportPlugin == null) continue;
                try {
                    reportPlugin.initialize(new HashMap<String, Object>(properties));
                }
                catch (AnalysisListenerException e) {
                    throw new PluginRepositoryException("Cannot initialize plugin " + reportPluginName, e);
                }
                reportPlugins.add(reportPlugin);
            }
        }
        return reportPlugins;
    }
}

