/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.plugin.api.ModelPluginRepository;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.impl.AbstractPluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ModelType;
import java.util.ArrayList;
import java.util.List;

public class ModelPluginRepositoryImpl
extends AbstractPluginRepository
implements ModelPluginRepository {
    private final List<Class<?>> descriptorTypes;

    public ModelPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) throws PluginRepositoryException {
        super(pluginConfigurationReader);
        List<JqassistantPlugin> plugins = pluginConfigurationReader.getPlugins();
        this.descriptorTypes = this.getDescriptorTypes(plugins);
    }

    @Override
    public List<Class<?>> getDescriptorTypes() throws PluginRepositoryException {
        return this.descriptorTypes;
    }

    private List<Class<?>> getDescriptorTypes(List<JqassistantPlugin> plugins) throws PluginRepositoryException {
        ArrayList types = new ArrayList();
        for (JqassistantPlugin plugin : plugins) {
            ModelType modelType = plugin.getModel();
            if (modelType == null) continue;
            for (String typeName : modelType.getClazz()) {
                types.add(this.getType(typeName));
            }
        }
        return types;
    }
}

