/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.sensor;

import com.buschmais.jqassistant.core.report.schema.v1.ColumnType;
import com.buschmais.jqassistant.core.report.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.report.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.report.schema.v1.ElementType;
import com.buschmais.jqassistant.core.report.schema.v1.GroupType;
import com.buschmais.jqassistant.core.report.schema.v1.JqassistantReport;
import com.buschmais.jqassistant.core.report.schema.v1.ObjectFactory;
import com.buschmais.jqassistant.core.report.schema.v1.ResultType;
import com.buschmais.jqassistant.core.report.schema.v1.RowType;
import com.buschmais.jqassistant.core.report.schema.v1.RuleType;
import com.buschmais.jqassistant.core.report.schema.v1.SourceType;
import com.buschmais.jqassistant.sonar.plugin.sensor.LanguageResourceResolver;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.SonarException;

public class JQAssistantSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQAssistantSensor.class);
    private final Settings settings;
    private final ModuleFileSystem moduleFileSystem;
    private final ResourcePerspectives perspectives;
    private final Map<String, LanguageResourceResolver> languageResourceResolvers;
    private final Map<String, ActiveRule> rules;
    private final JAXBContext reportContext;

    public JQAssistantSensor(RulesProfile profile, ResourcePerspectives perspectives, ComponentContainer componentContainerc, Settings settings, ModuleFileSystem moduleFileSystem) throws JAXBException {
        this.settings = settings;
        this.moduleFileSystem = moduleFileSystem;
        this.perspectives = perspectives;
        this.languageResourceResolvers = new HashMap<String, LanguageResourceResolver>();
        for (LanguageResourceResolver resolver : componentContainerc.getComponentsByType(LanguageResourceResolver.class)) {
            this.languageResourceResolvers.put(resolver.getLanguage(), resolver);
        }
        LOGGER.info("Found {} language resource resolvers.", (Object)this.languageResourceResolvers.size());
        this.rules = new HashMap<String, ActiveRule>();
        for (ActiveRule activeRule : profile.getActiveRulesByRepository("jqassistant")) {
            this.rules.put(activeRule.getRule().getName(), activeRule);
        }
        this.reportContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File reportFile = this.getReportFile();
        if (reportFile != null) {
            JqassistantReport report = this.readReport(reportFile);
            this.evaluateReport(project, sensorContext, report);
        }
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public String toString() {
        return "jQAssistant Sensor";
    }

    private JqassistantReport readReport(File reportFile) {
        try {
            Unmarshaller unmarshaller = this.reportContext.createUnmarshaller();
            return (JqassistantReport)unmarshaller.unmarshal((Source)new StreamSource(reportFile), JqassistantReport.class).getValue();
        }
        catch (JAXBException e) {
            throw new SonarException("Cannot read jQAssistant report from file " + reportFile, (Throwable)e);
        }
    }

    private void evaluateReport(Project project, SensorContext sensorContext, JqassistantReport report) {
        boolean createEmptyConceptIssue = this.isCreateEmptyConceptIssue();
        for (GroupType groupType : report.getGroup()) {
            LOGGER.info("Processing group '{}'", (Object)groupType.getId());
            for (RuleType ruleType : groupType.getConceptOrConstraint()) {
                boolean hasRows;
                String id = ruleType.getId();
                ActiveRule activeRule = this.rules.get(id);
                if (activeRule == null) {
                    LOGGER.warn("Cannot resolve activeRule for id '{}'.", (Object)id);
                    continue;
                }
                ResultType result = ruleType.getResult();
                boolean bl = hasRows = result != null && result.getRows().getCount() > 0;
                if (ruleType instanceof ConceptType && createEmptyConceptIssue && !hasRows) {
                    this.createIssue(project, null, "The concept did not return a result.", activeRule, sensorContext);
                    continue;
                }
                if (!(ruleType instanceof ConstraintType) || !hasRows) continue;
                for (RowType rowType : result.getRows().getRow()) {
                    StringBuilder message = new StringBuilder();
                    Resource<?> resource = null;
                    Integer lineNumber = null;
                    for (ColumnType column : rowType.getColumn()) {
                        LanguageResourceResolver resourceResolver;
                        String name = column.getName();
                        String value = column.getValue();
                        ElementType languageElement = column.getElement();
                        if (languageElement != null && (resourceResolver = this.languageResourceResolvers.get(languageElement.getLanguage())) != null) {
                            String element = languageElement.getValue();
                            resource = resourceResolver.resolve(element, value);
                        }
                        SourceType source = column.getSource();
                        lineNumber = source.getLine();
                        if (message.length() > 0) {
                            message.append(", ");
                        }
                        message.append(name);
                        message.append('=');
                        message.append(value);
                    }
                    if (resource == null) {
                        resource = project;
                    }
                    String issueDescription = ruleType.getDescription() + "\n" + message.toString();
                    this.createIssue(resource, lineNumber, issueDescription, activeRule, sensorContext);
                }
            }
        }
    }

    private void createIssue(Resource<?> resource, Integer lineNumber, String message, ActiveRule rule, SensorContext sensorContext) {
        if (sensorContext.getResource(resource) != null) {
            Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, resource);
            Issuable.IssueBuilder issueBuilder = issuable.newIssueBuilder().ruleKey(rule.getRule().ruleKey()).message(message);
            if (lineNumber != null) {
                issueBuilder.line(lineNumber);
            }
            issuable.addIssue(issueBuilder.build());
            LOGGER.info("Issue added for resource '{}'.", (Object)resource.getLongName());
        } else {
            LOGGER.warn("Resource '{}' not found, issue not created.", (Object)resource.getLongName());
        }
    }

    private File getReportFile() {
        File reportFile;
        String configReportPath = this.settings.getString("sonar.jqassistant.reportPath");
        if (configReportPath != null && !configReportPath.isEmpty()) {
            LOGGER.info("Using setting '{}' = '{}' to find report file.", (Object)"sonar.jqassistant.reportPath", (Object)configReportPath);
            reportFile = new File(configReportPath);
        } else {
            File buildDir = this.moduleFileSystem.buildDir();
            LOGGER.info("Using build directory '{}' to find report file.", (Object)buildDir);
            reportFile = new File(buildDir, "jqassistant/jqassistant-report.xml");
        }
        if (reportFile.exists()) {
            LOGGER.info("Report found at '{}'.", (Object)reportFile.getAbsolutePath());
            return reportFile;
        }
        LOGGER.info("No report found at '{}'.", (Object)reportFile.getAbsolutePath());
        return null;
    }

    private boolean isCreateEmptyConceptIssue() {
        if (!this.settings.hasKey("sonar.jqassistant.createEmptyConceptIssue")) {
            return true;
        }
        return this.settings.getBoolean("sonar.jqassistant.createEmptyConceptIssue");
    }
}

