/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.rule;

import com.buschmais.jqassistant.core.analysis.api.rule.AbstractExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.XmlRuleSetReader;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.sonar.plugin.rule.ConceptTemplateRule;
import com.buschmais.jqassistant.sonar.plugin.rule.ConstraintTemplateRule;
import com.buschmais.jqassistant.sonar.plugin.rule.RuleParameter;
import com.buschmais.jqassistant.sonar.plugin.rule.RuleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.sonar.api.rules.AnnotationRuleParser;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RuleRepository;
import org.sonar.api.utils.SonarException;

public final class JQAssistantRuleRepository
extends RuleRepository {
    public static final Collection<Class> RULE_CLASSES = Arrays.asList(ConceptTemplateRule.class, ConstraintTemplateRule.class);
    private final AnnotationRuleParser annotationRuleParser;

    public JQAssistantRuleRepository(AnnotationRuleParser annotationRuleParser) {
        super("jqassistant", "java");
        this.setName("jQAssistant");
        this.annotationRuleParser = annotationRuleParser;
    }

    public List<Rule> createRules() {
        RulePluginRepositoryImpl rulePluginRepository;
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(JQAssistantRuleRepository.class.getClassLoader());
        try {
            rulePluginRepository = new RulePluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        }
        catch (PluginRepositoryException e) {
            throw new SonarException("Cannot read rules.", (Throwable)e);
        }
        List ruleSources = rulePluginRepository.getRuleSources();
        XmlRuleSetReader ruleSetReader = new XmlRuleSetReader();
        RuleSet ruleSet = ruleSetReader.read(ruleSources);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Concept concept : ruleSet.getConcepts().values()) {
            rules.add(this.createRule((AbstractExecutableRule)concept, RuleType.Concept));
        }
        for (Constraint constraint : ruleSet.getConstraints().values()) {
            rules.add(this.createRule((AbstractExecutableRule)constraint, RuleType.Constraint));
        }
        rules.addAll(this.annotationRuleParser.parse("jqassistant", RULE_CLASSES));
        return rules;
    }

    private Rule createRule(AbstractExecutableRule executable, RuleType ruleType) {
        Rule rule = Rule.create((String)"jqassistant", (String)executable.getId(), (String)executable.getId());
        rule.setDescription(executable.getDescription());
        rule.setSeverity(RulePriority.valueOf((String)executable.getSeverity().name()));
        StringBuilder requiresConcepts = new StringBuilder();
        for (String requiredConcept : executable.getRequiresConcepts()) {
            if (requiresConcepts.length() > 0) {
                requiresConcepts.append(",");
            }
            requiresConcepts.append(requiredConcept);
        }
        this.createRuleParameter(rule, RuleParameter.Type, ruleType.name());
        this.createRuleParameter(rule, RuleParameter.RequiresConcepts, requiresConcepts.toString());
        this.createRuleParameter(rule, RuleParameter.Cypher, executable.getCypher());
        return rule;
    }

    private RuleParam createRuleParameter(Rule rule, RuleParameter ruleParameterDefinition, String value) {
        RuleParam parameter = rule.createParameter(ruleParameterDefinition.getName());
        parameter.setDefaultValue(value);
        return parameter;
    }
}

