/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.profile;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.DefaultRuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.impl.RuleSetWriterImpl;
import com.buschmais.jqassistant.sonar.plugin.rule.AbstractTemplateRule;
import com.buschmais.jqassistant.sonar.plugin.rule.ConceptTemplateRule;
import com.buschmais.jqassistant.sonar.plugin.rule.ConstraintTemplateRule;
import com.buschmais.jqassistant.sonar.plugin.rule.JQAssistantRuleRepository;
import com.buschmais.jqassistant.sonar.plugin.rule.RuleParameter;
import com.buschmais.jqassistant.sonar.plugin.rule.RuleType;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.utils.SonarException;

public class JQAssistantProfileExporter
extends ProfileExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQAssistantProfileExporter.class);
    private final RuleFinder ruleFinder;

    public JQAssistantProfileExporter(RuleFinder ruleFinder) {
        super("jqassistant", "jQAssistant");
        this.ruleFinder = ruleFinder;
        super.setMimeType("application/xml");
    }

    public void exportProfile(RulesProfile profile, Writer writer) {
        AnnotationCheckFactory annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"jqassistant", JQAssistantRuleRepository.RULE_CLASSES);
        HashMap<String, Concept> concepts = new HashMap<String, Concept>();
        HashMap<String, Severity> conceptsOfGroup = new HashMap<String, Severity>();
        HashMap<String, Severity> constraintsOfGroup = new HashMap<String, Severity>();
        HashMap<String, Constraint> constraints = new HashMap<String, Constraint>();
        HashMap<AbstractExecutableRule, Set> executables = new HashMap<AbstractExecutableRule, Set>();
        for (ActiveRule activeRule : profile.getActiveRulesByRepository("jqassistant")) {
            AbstractTemplateRule check = (AbstractTemplateRule)annotationCheckFactory.getCheck(activeRule);
            AbstractExecutableRule executable = check == null ? this.createExecutableFromActiveRule(activeRule) : this.createExecutableFromTemplate(activeRule, check);
            Set requiresConcepts = executable.getRequiresConcepts();
            executables.put(executable, requiresConcepts);
            if (executable instanceof Concept) {
                concepts.put(executable.getId(), (Concept)executable);
                conceptsOfGroup.put(executable.getId(), executable.getSeverity());
                continue;
            }
            if (!(executable instanceof Constraint)) continue;
            constraints.put(executable.getId(), (Constraint)executable);
            constraintsOfGroup.put(executable.getId(), executable.getSeverity());
        }
        for (Set requiredConcepts : executables.values()) {
            this.resolveRequiredConcepts(requiredConcepts, concepts);
        }
        Group group = new Group(profile.getName(), null, conceptsOfGroup, constraintsOfGroup, Collections.emptySet());
        HashMap<String, Group> groups = new HashMap<String, Group>();
        groups.put(group.getId(), group);
        DefaultRuleSet ruleSet = new DefaultRuleSet(Collections.emptyMap(), concepts, constraints, groups, Collections.emptyMap());
        RuleSetWriterImpl ruleSetWriter = new RuleSetWriterImpl();
        LOGGER.debug("Exporting rule set " + ruleSet.toString());
        try {
            ruleSetWriter.write((RuleSet)ruleSet, writer);
        }
        catch (AnalysisException e) {
            throw new SonarException("Cannot export rule set.", (Throwable)e);
        }
    }

    private Set<String> getRequiresConcepts(String requiresConcepts) {
        return new HashSet<String>(Arrays.asList(StringUtils.splitByWholeSeparator((String)requiresConcepts, (String)",")));
    }

    private Set<String> getRequiredConcepts(String requiresConcepts) {
        HashSet<String> result = new HashSet<String>();
        if (!StringUtils.isEmpty((String)requiresConcepts)) {
            for (String requiresConceptId : StringUtils.splitByWholeSeparator((String)requiresConcepts, (String)",")) {
                result.add(requiresConceptId);
            }
        }
        return result;
    }

    private void resolveRequiredConcepts(Set<String> requiredConcepts, Map<String, Concept> concepts) {
        for (String requiredConcept : requiredConcepts) {
            this.resolveRequiredConcepts(requiredConcept, concepts);
        }
    }

    private void resolveRequiredConcepts(String requiredConceptId, Map<String, Concept> concepts) {
        LOGGER.debug("Required concept: " + requiredConceptId);
        Concept requiredConcept = concepts.get(requiredConceptId);
        if (requiredConcept == null) {
            LOGGER.debug("Finding rule for concept : " + requiredConceptId);
            Rule rule = this.ruleFinder.findByKey("jqassistant", requiredConceptId);
            requiredConcept = (Concept)this.createExecutableFromRule(rule);
            concepts.put(requiredConceptId, requiredConcept);
            RuleParam requiresConceptsParam = rule.getParam(RuleParameter.RequiresConcepts.getName());
            if (requiresConceptsParam != null) {
                Set<String> requiredConcepts = this.getRequiredConcepts(requiresConceptsParam.getDefaultValue());
                this.resolveRequiredConcepts(requiredConcepts, concepts);
            }
        }
        if (requiredConcept != null) {
            LOGGER.debug("Adding required concept with id " + requiredConceptId);
        } else {
            LOGGER.warn("Cannot resolve required concept with id " + requiredConceptId);
        }
    }

    private AbstractExecutableRule createExecutableFromActiveRule(ActiveRule activeRule) {
        return this.createExecutableFromRule(activeRule.getRule());
    }

    private AbstractExecutableRule createExecutableFromRule(Rule rule) {
        RuleParam cypherParam = rule.getParam(RuleParameter.Cypher.getName());
        if (cypherParam == null) {
            throw new SonarException("Cannot determine cypher for " + rule);
        }
        String cypher = cypherParam.getDefaultValue();
        RuleParam requiresConceptsParam = rule.getParam(RuleParameter.RequiresConcepts.getName());
        Set<String> requiresConcepts = requiresConceptsParam != null ? this.getRequiresConcepts(requiresConceptsParam.getDefaultValue()) : Collections.emptySet();
        return this.createExecutableFromRule(rule, cypher, requiresConcepts);
    }

    private AbstractExecutableRule createExecutableFromRule(Rule rule, String cypher, Set<String> requiresConcepts) {
        Concept executable;
        RuleParam typeParam = rule.getParam(RuleParameter.Type.getName());
        if (typeParam == null) {
            throw new SonarException("Cannot determine type of rule for " + rule);
        }
        String type = typeParam.getDefaultValue();
        RuleType ruleType = RuleType.valueOf(type);
        String id = rule.getName();
        String description = rule.getDescription();
        Severity severity = Severity.valueOf((String)rule.getSeverity().name());
        switch (ruleType) {
            case Concept: {
                executable = new Concept(id, description, severity, null, cypher, null, null, null, requiresConcepts);
                break;
            }
            case Constraint: {
                executable = new Constraint(id, description, severity, null, cypher, null, null, null, requiresConcepts);
                break;
            }
            default: {
                throw new SonarException("Rule type is not supported " + (Object)((Object)ruleType));
            }
        }
        return executable;
    }

    private AbstractExecutableRule createExecutableFromTemplate(ActiveRule activeRule, AbstractTemplateRule check) {
        Concept executable;
        String id = activeRule.getRule().getName();
        String description = activeRule.getRule().getDescription();
        Severity severity = Severity.valueOf((String)activeRule.getSeverity().name());
        String cypher = check.getCypher();
        Set<String> requiresConcepts = this.getRequiresConcepts(check.getRequiresConcepts());
        if (check instanceof ConceptTemplateRule) {
            executable = new Concept(id, description, severity, null, cypher, null, null, null, requiresConcepts);
        } else if (check instanceof ConstraintTemplateRule) {
            executable = new Constraint(id, description, severity, null, cypher, null, null, null, requiresConcepts);
        } else {
            throw new SonarException("Unknown type " + check.getClass());
        }
        return executable;
    }
}

