/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.impl;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.scanner.impl.ScannerContextImpl;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.xo.spi.reflection.DependencyResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerImpl
implements Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannerImpl.class);
    private final ScannerContext scannerContext;
    private final List<ScannerPlugin<?, ?>> scannerPlugins;
    private final Map<Class<?>, List<ScannerPlugin<?, ?>>> scannerPluginsPerType = new HashMap();
    private final Map<String, Scope> scopes;

    public ScannerImpl(Store store, List<ScannerPlugin<?, ?>> scannerPlugins, Map<String, Scope> scopes) {
        this.scannerPlugins = scannerPlugins;
        this.scopes = scopes;
        this.scannerContext = new ScannerContextImpl(store);
        this.scannerContext.push(Scope.class, null);
    }

    @Override
    public <I, D extends Descriptor> D scan(I item, String path, Scope scope) {
        Object descriptor = null;
        Class<?> itemClass = item.getClass();
        for (ScannerPlugin<?, ?> scannerPlugin : this.getScannerPluginsForType(itemClass)) {
            ScannerPlugin<?, ?> selectedPlugin = scannerPlugin;
            if (!this.accepts(selectedPlugin, item, path, scope)) continue;
            this.pushDesriptor(descriptor);
            this.enterScope(scope);
            Object newDescriptor = null;
            try {
                newDescriptor = selectedPlugin.scan(item, path, scope, this);
            }
            catch (Exception e) {
                LOGGER.error("Cannot scan item " + path, (Throwable)e);
            }
            this.leaveScope(scope);
            this.popDescriptor(descriptor);
            descriptor = newDescriptor;
        }
        return descriptor;
    }

    private <I> boolean accepts(ScannerPlugin<I, ?> selectedPlugin, I item, String path, Scope scope) {
        try {
            return selectedPlugin.accepts(item, path, scope);
        }
        catch (IOException e) {
            LOGGER.error("Plugin " + selectedPlugin + " cannot check if it accepts item " + path, (Throwable)e);
            return false;
        }
    }

    private <D extends Descriptor> void pushDesriptor(D descriptor) {
        if (descriptor != null) {
            for (Class<?> type : descriptor.getClass().getInterfaces()) {
                this.scannerContext.push(type, descriptor);
            }
        }
    }

    private <D extends Descriptor> void popDescriptor(D descriptor) {
        if (descriptor != null) {
            for (Class<?> type : descriptor.getClass().getInterfaces()) {
                this.scannerContext.pop(type);
            }
        }
    }

    @Override
    public ScannerContext getContext() {
        return this.scannerContext;
    }

    @Override
    public Scope resolveScope(String name) {
        if (name == null) {
            return DefaultScope.NONE;
        }
        Scope scope = this.scopes.get(name);
        if (scope == null) {
            LOGGER.warn("No scope found for name '" + name + "'.");
            scope = DefaultScope.NONE;
        }
        return scope;
    }

    private List<ScannerPlugin<?, ?>> getScannerPluginsForType(Class<?> type) {
        List plugins = this.scannerPluginsPerType.get(type);
        if (plugins == null) {
            LinkedList candidates = new LinkedList();
            final HashMap pluginsByDescriptor = new HashMap();
            for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins) {
                Class<?> scannerPluginType = scannerPlugin.getType();
                if (!scannerPluginType.isAssignableFrom(type)) continue;
                Class<?> descriptorType = scannerPlugin.getDescriptorType();
                HashSet pluginsForDescriptorType = (HashSet)pluginsByDescriptor.get(descriptorType);
                if (pluginsForDescriptorType == null) {
                    pluginsForDescriptorType = new HashSet();
                    pluginsByDescriptor.put(descriptorType, pluginsForDescriptorType);
                }
                pluginsForDescriptorType.add(scannerPlugin);
                candidates.add(scannerPlugin);
            }
            plugins = DependencyResolver.newInstance(candidates, (DependencyResolver.DependencyProvider)new DependencyResolver.DependencyProvider<ScannerPlugin<?, ?>>(){

                public Set<ScannerPlugin<?, ?>> getDependencies(ScannerPlugin<?, ?> dependent) {
                    HashSet dependencies = new HashSet();
                    ScannerPlugin.Requires annotation = dependent.getClass().getAnnotation(ScannerPlugin.Requires.class);
                    if (annotation != null) {
                        for (Class<? extends Descriptor> descriptorType : annotation.value()) {
                            Set pluginsByDescriptorType = (Set)pluginsByDescriptor.get(descriptorType);
                            if (pluginsByDescriptorType == null) continue;
                            for (ScannerPlugin scannerPlugin : pluginsByDescriptorType) {
                                if (scannerPlugin.equals(dependent)) continue;
                                dependencies.add(scannerPlugin);
                            }
                        }
                    }
                    return dependencies;
                }
            }).resolve();
            this.scannerPluginsPerType.put(type, plugins);
        }
        return plugins;
    }

    private void enterScope(Scope newScope) {
        Scope oldScope = this.scannerContext.peek(Scope.class);
        if (newScope != null && !newScope.equals(oldScope)) {
            newScope.create(this.scannerContext);
        }
        this.scannerContext.push(Scope.class, newScope);
    }

    private void leaveScope(Scope newScope) {
        this.scannerContext.pop(Scope.class);
        Scope oldScope = this.scannerContext.peek(Scope.class);
        if (newScope != null && !newScope.equals(oldScope)) {
            newScope.destroy(this.scannerContext);
        }
    }
}

