/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.facelet.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.facelet.api.model.JsfFaceletDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JsfFaceletScannerPlugin
extends AbstractScannerPlugin<FileResource, JsfFaceletDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsfFaceletScannerPlugin.class);
    private static final String DEFAULT_FILE_PATTERN = ".*\\.jspx";
    private static final String PROPERTY_NAME_FILE_PATTERN = "facelet.file.pattern";
    private DocumentBuilder documentBuilder;
    private Pattern filePattern;
    private Store store;
    private XPath xPath;

    protected void initialize() {
        this.filePattern = this.getProperties().containsKey(PROPERTY_NAME_FILE_PATTERN) ? Pattern.compile(this.getProperties().get(PROPERTY_NAME_FILE_PATTERN).toString()) : Pattern.compile(DEFAULT_FILE_PATTERN);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xPath = xPathfactory.newXPath();
        this.xPath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix != null) {
                    if (prefix.equals("")) {
                        return "http://www.w3.org/1999/xhtml";
                    }
                    if (prefix.equals("ui")) {
                        return "http://java.sun.com/jsf/facelets";
                    }
                    if (prefix.equals("h")) {
                        return "http://java.sun.com/jsf/html";
                    }
                    if (prefix.equals("f")) {
                        return "http://java.sun.com/jsf/core";
                    }
                }
                return "";
            }
        });
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn("Cannot set features of document builder factory.", (Throwable)e);
        }
        try {
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot create document builder.", e);
        }
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return this.filePattern.matcher(path).find();
    }

    public JsfFaceletDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        this.store = scanner.getContext().getStore();
        String currentFqn = this.normalizeFilePath(path);
        JsfFaceletDescriptor currentDescriptor = this.getJsfTemplateDescriptor(currentFqn);
        try {
            Document doc = this.getDocument(item);
            NodeList nodeList = (NodeList)this.getXPath().evaluate("//ui:include", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String includeSrc = node.getAttributes().getNamedItem("src").getNodeValue();
                JsfFaceletDescriptor includedJsf = this.findJsfTemplateDescriptor(currentFqn, includeSrc);
                if (includedJsf == null) continue;
                currentDescriptor.getIncludes().add(includedJsf);
            }
            String templateSrc = (String)this.getXPath().evaluate("//ui:composition/@template", doc, XPathConstants.STRING);
            if (StringUtils.isNotBlank((String)templateSrc)) {
                currentDescriptor.setTemplate(this.findJsfTemplateDescriptor(currentFqn, templateSrc));
            }
        }
        catch (XPathExpressionException | SAXException e) {
            throw new IOException(e);
        }
        return currentDescriptor;
    }

    private JsfFaceletDescriptor findJsfTemplateDescriptor(String templateFqn, String path) {
        String includedFile = this.absolutifyFilePath(path, templateFqn);
        JsfFaceletDescriptor includedFileDescriptor = this.getJsfTemplateDescriptor(includedFile);
        return includedFileDescriptor;
    }

    private String normalizeFilePath(String path) {
        String normalizedPath = path.replace('\\', '/');
        if (!normalizedPath.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        return normalizedPath;
    }

    private String absolutifyFilePath(String path, String referencePath) {
        if (this.isElExpression(path)) {
            return path;
        }
        String normalizedPath = path;
        if (!path.startsWith("/")) {
            Path reference = Paths.get(referencePath, new String[0]);
            normalizedPath = reference.getParent().resolve(path).normalize().toString();
        } else {
            normalizedPath = Paths.get(path, new String[0]).normalize().toString();
        }
        return this.normalizeFilePath(normalizedPath);
    }

    private Document getDocument(FileResource ressource) throws SAXException, IOException {
        return this.documentBuilder.parse(ressource.getFile());
    }

    private JsfFaceletDescriptor getJsfTemplateDescriptor(String fullFilePath) {
        if (this.isElExpression(fullFilePath)) {
            return null;
        }
        FileDescriptor jspxDescriptor = (FileDescriptor)this.store.find(FileDescriptor.class, fullFilePath);
        if (jspxDescriptor == null) {
            jspxDescriptor = (FileDescriptor)this.store.create(JsfFaceletDescriptor.class);
            jspxDescriptor.setFileName(fullFilePath);
        } else if (!(jspxDescriptor instanceof JsfFaceletDescriptor)) {
            jspxDescriptor = (FileDescriptor)this.store.migrate((Descriptor)jspxDescriptor, JsfFaceletDescriptor.class, new Class[0]);
        }
        return (JsfFaceletDescriptor)jspxDescriptor;
    }

    private boolean isElExpression(String str) {
        return str.startsWith("#{") || str.startsWith("${");
    }

    private XPath getXPath() {
        return this.xPath;
    }
}

