/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.common.report;

import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.report.api.LanguageHelper;
import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.util.Collection;
import java.util.Map;

public final class ReportHelper {
    private Console console;

    public ReportHelper(Console console) {
        this.console = console;
    }

    public int verifyConceptResults(InMemoryReportWriter inMemoryReportWriter) {
        Collection conceptResults = inMemoryReportWriter.getConceptResults().values();
        int violations = 0;
        for (Result conceptResult : conceptResults) {
            if (!conceptResult.getRows().isEmpty()) continue;
            this.console.error("Concept '" + ((Concept)conceptResult.getRule()).getId() + "' returned an empty result.");
            ++violations;
        }
        return violations;
    }

    public int verifyConstraintViolations(InMemoryReportWriter inMemoryReportWriter) {
        return this.verifyConstraintResults(Constraint.DEFAULT_SEVERITY, inMemoryReportWriter);
    }

    public int verifyConstraintResults(Severity severity, InMemoryReportWriter inMemoryReportWriter) {
        Collection constraintViolations = inMemoryReportWriter.getConstraintViolations().values();
        int violations = 0;
        for (Result constraintViolation : constraintViolations) {
            Constraint constraint;
            if (constraintViolation.isEmpty() || (constraint = (Constraint)constraintViolation.getRule()).getSeverity().getLevel() > severity.getLevel()) continue;
            this.console.error(constraint.getId() + ": " + constraint.getDescription());
            for (Map columns : constraintViolation.getRows()) {
                StringBuilder message = new StringBuilder();
                for (Map.Entry entry : columns.entrySet()) {
                    if (message.length() > 0) {
                        message.append(", ");
                    }
                    message.append((String)entry.getKey());
                    message.append('=');
                    String stringValue = this.getStringValue(entry.getValue());
                    message.append(stringValue);
                }
                this.console.error("  " + message.toString());
            }
            ++violations;
        }
        return violations;
    }

    private String getStringValue(Object value) {
        if (value != null) {
            if (value instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)value;
                LanguageElement elementValue = LanguageHelper.getLanguageElement((Descriptor)descriptor);
                if (elementValue != null) {
                    SourceProvider sourceProvider = elementValue.getSourceProvider();
                    return sourceProvider.getName(descriptor);
                }
            } else {
                if (value instanceof Iterable) {
                    StringBuffer sb = new StringBuffer();
                    for (Object o : (Iterable)value) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(this.getStringValue(o));
                    }
                    return "[" + sb.toString() + "]";
                }
                if (value instanceof Map) {
                    StringBuffer sb = new StringBuffer();
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append((String)entry.getKey());
                        sb.append(":");
                        sb.append(this.getStringValue(entry.getValue()));
                    }
                    return "{" + sb.toString() + "}";
                }
            }
            return value.toString();
        }
        return null;
    }
}

