/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps.cypher;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import javax.transaction.SystemException;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.cypher.javacompat.internal.ServerExecutionEngine;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.OutputAsWriter;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Start
extends TransactionProvidingApp {
    private ServerExecutionEngine engine;

    @Override
    public String getDescription() {
        String className = this.getClass().getSimpleName().toUpperCase();
        return MessageFormat.format("Executes a Cypher query. Usage: {0} <rest of query>;\nExample: MATCH (me)-[:KNOWS]->(you) RETURN you.name;\nwhere '{'self'}' will be replaced with the current location in the graph.Please, note that the query must end with a semicolon. Other parameters are\ntaken from shell variables, see ''help export''.", className);
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLine().trim();
        if (this.isComplete(query)) {
            try {
                long startTime = System.currentTimeMillis();
                ExecutionResult result = this.getResult(this.trimQuery(query), this.getParameters(session));
                this.handleResult(out, result, startTime, session, parser);
            }
            catch (SystemException | CypherException e) {
                throw ShellException.wrapCause(e);
            }
            return Continuation.INPUT_COMPLETE;
        }
        return Continuation.INPUT_INCOMPLETE;
    }

    protected ExecutionResult getResult(String query, Map<String, Object> parameters) throws ShellException, RemoteException, SystemException {
        return this.getEngine().execute(query, parameters);
    }

    protected String trimQuery(String query) {
        return query.substring(0, query.lastIndexOf(";"));
    }

    protected void handleResult(Output out, ExecutionResult result, long startTime, Session session, AppCommandParser parser) throws RemoteException, ShellException {
        this.printResult(out, result, startTime);
    }

    private void printResult(Output out, ExecutionResult result, long startTime) throws RemoteException {
        result.toString(new PrintWriter(new OutputAsWriter(out)));
        out.println((Serializable)((Object)(this.now() - startTime + " ms")));
    }

    protected StringLogger getCypherLogger() {
        DependencyResolver dependencyResolver = this.getServer().getDb().getDependencyResolver();
        Logging logging = dependencyResolver.resolveDependency(Logging.class);
        return logging.getMessagesLog(ExecutionEngine.class);
    }

    protected Map<String, Object> getParameters(Session session) throws ShellException {
        try {
            NodeOrRelationship self = this.getCurrent(session);
            session.set("self", self.isNode() ? self.asNode() : self.asRelationship());
        }
        catch (ShellException shellException) {
            // empty catch block
        }
        return session.asMap();
    }

    protected boolean isComplete(String query) {
        return query.endsWith(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerExecutionEngine getEngine() {
        if (this.engine == null) {
            Start start = this;
            synchronized (start) {
                if (this.engine == null) {
                    this.engine = new ServerExecutionEngine((GraphDatabaseService)this.getServer().getDb(), this.getCypherLogger());
                }
            }
        }
        return this.engine;
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

