/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps.cypher;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.cypher.Start;

public class Profile
extends Start {
    @Override
    public String getDescription() {
        return "Executes a Cypher query and prints out execution plan and other profiling information. Usage: profile <query>\nExample: PROFILE START me = node({self}) MATCH me-[:KNOWS]->you RETURN you.name\nwhere {self} will be replaced with the current location in the graph";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLineWithoutApp();
        if (this.isComplete(query)) {
            ExecutionEngine engine = new ExecutionEngine((GraphDatabaseService)this.getServer().getDb(), this.getCypherLogger());
            try {
                ExecutionResult result = engine.profile(query, this.getParameters(session));
                out.println((Serializable)((Object)result.dumpToString()));
                out.println((Serializable)((Object)result.executionPlanDescription().toString()));
            }
            catch (CypherException e) {
                throw ShellException.wrapCause(e);
            }
            return Continuation.INPUT_COMPLETE;
        }
        return Continuation.INPUT_INCOMPLETE;
    }
}

