/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;

public class Begin
extends NonTransactionProvidingApp {
    private static String TRANSACTION = "TRANSACTION";

    @Override
    public String getDescription() {
        return "Opens a transaction";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        int count;
        String lineWithoutApp = parser.getLineWithoutApp();
        if (!this.acceptableText(lineWithoutApp)) {
            out.println((Serializable)((Object)"Error: To open a transaction, write BEGIN TRANSACTION"));
            return Continuation.INPUT_COMPLETE;
        }
        Transaction tx = Begin.currentTransaction(this.getServer());
        this.getServer().getDb().beginTx();
        Integer txCount = session.getCommitCount();
        if (txCount == null) {
            if (tx == null) {
                count = 0;
                out.println((Serializable)((Object)"Transaction started"));
            } else {
                count = 1;
                out.println((Serializable)((Object)"Warning: transaction found that was not started by the shell."));
            }
        } else {
            count = txCount;
            out.println((Serializable)((Object)String.format("Nested transaction started (Tx count: %d)", count + 1)));
        }
        session.setCommitCount(++count);
        return Continuation.INPUT_COMPLETE;
    }

    private boolean acceptableText(String line) {
        if (line == null || line.length() > TRANSACTION.length()) {
            return false;
        }
        String substring = TRANSACTION.substring(0, line.length());
        return substring.equals(line.toUpperCase());
    }

    public static Transaction currentTransaction(GraphDatabaseShellServer server) throws ShellException {
        try {
            return server.getDb().getDependencyResolver().resolveDependency(TransactionManager.class).getTransaction();
        }
        catch (SystemException e) {
            throw new ShellException(e.getMessage());
        }
    }
}

