/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.traversal.OldTraverserWrapper;

public class ReadOnlyGraphDatabaseProxy
implements GraphDatabaseService,
GraphDatabaseAPI,
IndexManager {
    private final GraphDatabaseAPI actual;

    public ReadOnlyGraphDatabaseProxy(GraphDatabaseAPI graphDb) {
        this.actual = graphDb;
    }

    public Node readOnly(Node actual) {
        return new ReadOnlyNodeProxy(actual);
    }

    public Relationship readOnly(Relationship actual) {
        return new ReadOnlyRelationshipProxy(actual);
    }

    private static <T> T readOnly() {
        throw ReadOnlyGraphDatabaseProxy.readOnlyException();
    }

    private static UnsupportedOperationException readOnlyException() {
        return new UnsupportedOperationException("Read only Graph Database!");
    }

    @Override
    public Transaction beginTx() {
        return this.actual.beginTx();
    }

    @Override
    public Node createNode() {
        return (Node)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    @Override
    public Node createNode(Label ... labels) {
        return (Node)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public boolean enableRemoteShell() {
        throw new UnsupportedOperationException("Cannot enable Remote Shell from Remote Shell");
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.enableRemoteShell();
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.nodes(this.actual.getAllNodes());
    }

    @Override
    public Node getNodeById(long id) {
        return new ReadOnlyNodeProxy(this.actual.getNodeById(id));
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return new ReadOnlyRelationshipProxy(this.actual.getRelationshipById(id));
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.actual.getRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    @Override
    public boolean isAvailable(long timeout) {
        return this.actual.isAvailable(timeout);
    }

    @Override
    public void shutdown() {
        this.actual.shutdown();
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return (KernelEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    @Override
    public Schema schema() {
        return new ReadOnlySchemaProxy(this.actual.schema());
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return (TransactionEventHandler)ReadOnlyGraphDatabaseProxy.readOnly();
    }

    public Iterable<Node> nodes(Iterable<Node> nodes) {
        return new IterableWrapper<Node, Node>(nodes){

            @Override
            protected Node underlyingObjectToObject(Node node) {
                return new ReadOnlyNodeProxy(node);
            }
        };
    }

    public Iterable<Relationship> relationships(Iterable<Relationship> relationships) {
        return new IterableWrapper<Relationship, Relationship>(relationships){

            @Override
            protected Relationship underlyingObjectToObject(Relationship relationship) {
                return new ReadOnlyRelationshipProxy(relationship);
            }
        };
    }

    @Override
    public boolean existsForNodes(String indexName) {
        return this.actual.index().existsForNodes(indexName);
    }

    @Override
    public Index<Node> forNodes(String indexName) {
        return new ReadOnlyNodeIndexProxy(this.actual.index().forNodes(indexName, null));
    }

    @Override
    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyNodeIndexProxy(this.actual.index().forNodes(indexName, customConfiguration));
    }

    @Override
    public String[] nodeIndexNames() {
        return this.actual.index().nodeIndexNames();
    }

    @Override
    public boolean existsForRelationships(String indexName) {
        return this.actual.index().existsForRelationships(indexName);
    }

    @Override
    public RelationshipIndex forRelationships(String indexName) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, null));
    }

    @Override
    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        return new ReadOnlyRelationshipIndexProxy(this.actual.index().forRelationships(indexName, customConfiguration));
    }

    @Override
    public String[] relationshipIndexNames() {
        return this.actual.index().relationshipIndexNames();
    }

    @Override
    public IndexManager index() {
        return this;
    }

    @Override
    public TraversalDescription traversalDescription() {
        return this.actual.traversalDescription();
    }

    @Override
    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return this.actual.bidirectionalTraversalDescription();
    }

    @Override
    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        return this.actual.index().getConfiguration(index);
    }

    @Override
    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        throw new ReadOnlyDbException();
    }

    @Override
    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        throw new ReadOnlyDbException();
    }

    @Override
    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.actual.index().getNodeAutoIndexer();
    }

    @Override
    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.actual.index().getRelationshipAutoIndexer();
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.actual.getDependencyResolver();
    }

    @Override
    public String getStoreDir() {
        return this.actual.getStoreDir();
    }

    @Override
    public TransactionBuilder tx() {
        return this.actual.tx();
    }

    @Override
    public StoreId storeId() {
        return this.actual.storeId();
    }

    @Override
    public ResourceIterable<Node> findNodesByLabelAndProperty(Label label, String key, Object value) {
        return this.actual.findNodesByLabelAndProperty(label, key, value);
    }

    private class ReadOnlySchemaProxy
    implements Schema {
        private final Schema actual;

        public ReadOnlySchemaProxy(Schema actual) {
            this.actual = actual;
        }

        @Override
        public IndexCreator indexFor(Label label) {
            throw ReadOnlyGraphDatabaseProxy.readOnlyException();
        }

        @Override
        public Iterable<IndexDefinition> getIndexes(Label label) {
            return this.actual.getIndexes(label);
        }

        @Override
        public Iterable<IndexDefinition> getIndexes() {
            return this.actual.getIndexes();
        }

        @Override
        public Schema.IndexState getIndexState(IndexDefinition index) {
            return this.actual.getIndexState(index);
        }

        @Override
        public String getIndexFailure(IndexDefinition index) {
            return this.actual.getIndexFailure(index);
        }

        @Override
        public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
            this.actual.awaitIndexOnline(index, duration, unit);
        }

        @Override
        public void awaitIndexesOnline(long duration, TimeUnit unit) {
            this.actual.awaitIndexesOnline(duration, unit);
        }

        @Override
        public ConstraintCreator constraintFor(Label label) {
            throw ReadOnlyGraphDatabaseProxy.readOnlyException();
        }

        @Override
        public Iterable<ConstraintDefinition> getConstraints() {
            return this.actual.getConstraints();
        }

        @Override
        public Iterable<ConstraintDefinition> getConstraints(Label label) {
            return this.actual.getConstraints(label);
        }
    }

    private static class ReadOnlyIndexHitsProxy<T extends PropertyContainer>
    implements IndexHits<T> {
        private final ReadOnlyIndexProxy<T, ?> index;
        private final IndexHits<T> actual;

        ReadOnlyIndexHitsProxy(ReadOnlyIndexProxy<T, ?> index, IndexHits<T> actual) {
            this.index = index;
            this.actual = actual;
        }

        @Override
        public void close() {
            this.actual.close();
        }

        @Override
        public T getSingle() {
            return (T)this.index.wrap((PropertyContainer)this.actual.getSingle());
        }

        @Override
        public int size() {
            return this.actual.size();
        }

        @Override
        public boolean hasNext() {
            return this.actual.hasNext();
        }

        @Override
        public T next() {
            return (T)this.index.wrap((PropertyContainer)this.actual.next());
        }

        @Override
        public void remove() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public ResourceIterator<T> iterator() {
            return this;
        }

        @Override
        public float currentScore() {
            return this.actual.currentScore();
        }
    }

    class ReadOnlyRelationshipIndexProxy
    extends ReadOnlyIndexProxy<Relationship, RelationshipIndex>
    implements RelationshipIndex {
        ReadOnlyRelationshipIndexProxy(RelationshipIndex actual) {
            super(ReadOnlyGraphDatabaseProxy.this, (Index)actual);
        }

        @Override
        Relationship wrap(Relationship actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        @Override
        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).get(key, valueOrNull, startNodeOrNull, endNodeOrNull));
        }

        @Override
        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(key, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        @Override
        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return new ReadOnlyIndexHitsProxy<Relationship>(this, ((RelationshipIndex)this.actual).query(queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull));
        }

        @Override
        public String getName() {
            return ((RelationshipIndex)this.actual).getName();
        }

        @Override
        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }
    }

    class ReadOnlyNodeIndexProxy
    extends ReadOnlyIndexProxy<Node, Index<Node>> {
        ReadOnlyNodeIndexProxy(Index<Node> actual) {
            super(ReadOnlyGraphDatabaseProxy.this, actual);
        }

        @Override
        Node wrap(Node actual) {
            return ReadOnlyGraphDatabaseProxy.this.readOnly(actual);
        }

        @Override
        public String getName() {
            return this.actual.getName();
        }

        @Override
        public Class<Node> getEntityType() {
            return Node.class;
        }
    }

    static abstract class ReadOnlyIndexProxy<T extends PropertyContainer, I extends Index<T>>
    implements Index<T> {
        final I actual;
        final /* synthetic */ ReadOnlyGraphDatabaseProxy this$0;

        ReadOnlyIndexProxy(I actual) {
            this.this$0 = var1_1;
            this.actual = actual;
        }

        abstract T wrap(T var1);

        @Override
        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void add(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public T putIfAbsent(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
            return null;
        }

        @Override
        public IndexHits<T> get(String key, Object value) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.get(key, value));
        }

        @Override
        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(key, queryOrQueryObject));
        }

        @Override
        public IndexHits<T> query(Object queryOrQueryObject) {
            return new ReadOnlyIndexHitsProxy(this, this.actual.query(queryOrQueryObject));
        }

        @Override
        public void remove(T entity, String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void remove(T entity, String key) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void remove(T entity) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public boolean isWriteable() {
            return false;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return this.actual.getGraphDatabase();
        }
    }

    private class ReadOnlyRelationshipProxy
    implements Relationship {
        private final Relationship actual;

        ReadOnlyRelationshipProxy(Relationship actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Relationship && ((Relationship)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        @Override
        public long getId() {
            return this.actual.getId();
        }

        @Override
        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public Node getEndNode() {
            return new ReadOnlyNodeProxy(this.actual.getEndNode());
        }

        @Override
        public Node[] getNodes() {
            return new Node[]{this.getStartNode(), this.getEndNode()};
        }

        @Override
        public Node getOtherNode(Node node) {
            return new ReadOnlyNodeProxy(this.actual.getOtherNode(node));
        }

        @Override
        public Node getStartNode() {
            return new ReadOnlyNodeProxy(this.actual.getStartNode());
        }

        @Override
        public RelationshipType getType() {
            return this.actual.getType();
        }

        @Override
        public boolean isType(RelationshipType type) {
            return this.actual.isType(type);
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        @Override
        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        @Override
        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }
    }

    private class ReadOnlyNodeProxy
    implements Node {
        private final Node actual;

        ReadOnlyNodeProxy(Node actual) {
            this.actual = actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && ((Node)obj).getId() == this.getId();
        }

        public String toString() {
            return this.actual.toString();
        }

        @Override
        public long getId() {
            return this.actual.getId();
        }

        @Override
        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return (Relationship)ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void delete() {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public Iterable<Relationship> getRelationships() {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships());
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(types));
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(direction, types));
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(dir));
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            return ReadOnlyGraphDatabaseProxy.this.relationships(this.actual.getRelationships(type, dir));
        }

        @Override
        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return new ReadOnlyRelationshipProxy(this.actual.getSingleRelationship(type, dir));
        }

        @Override
        public boolean hasRelationship() {
            return this.actual.hasRelationship();
        }

        @Override
        public boolean hasRelationship(RelationshipType ... types) {
            return this.actual.hasRelationship(types);
        }

        @Override
        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return this.actual.hasRelationship(direction, types);
        }

        @Override
        public boolean hasRelationship(Direction dir) {
            return this.actual.hasRelationship(dir);
        }

        @Override
        public boolean hasRelationship(RelationshipType type, Direction dir) {
            return this.actual.hasRelationship(type, dir);
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{relationshipType, direction});
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, new Object[]{firstRelationshipType, firstDirection, secondRelationshipType, secondDirection});
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            return OldTraverserWrapper.traverse(this, traversalOrder, stopEvaluator, returnableEvaluator, relationshipTypesAndDirections);
        }

        @Override
        public void addLabel(Label label) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void removeLabel(Label label) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public boolean hasLabel(Label label) {
            return this.actual.hasLabel(label);
        }

        @Override
        public Iterable<Label> getLabels() {
            return this.actual.getLabels();
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return ReadOnlyGraphDatabaseProxy.this;
        }

        @Override
        public Object getProperty(String key) {
            return this.actual.getProperty(key);
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            return this.actual.getProperty(key, defaultValue);
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.actual.getPropertyKeys();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.actual.hasProperty(key);
        }

        @Override
        public Object removeProperty(String key) {
            return ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public void setProperty(String key, Object value) {
            ReadOnlyGraphDatabaseProxy.readOnly();
        }

        @Override
        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        @Override
        public int getDegree() {
            return this.actual.getDegree();
        }

        @Override
        public int getDegree(RelationshipType type) {
            return this.actual.getDegree(type);
        }

        @Override
        public int getDegree(Direction direction) {
            return this.actual.getDegree(direction);
        }

        @Override
        public int getDegree(RelationshipType type, Direction direction) {
            return this.actual.getDegree(type, direction);
        }
    }
}

