/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.impl.AbstractAppServer;
import org.neo4j.shell.impl.BashVariableInterpreter;
import org.neo4j.shell.kernel.ReadOnlyGraphDatabaseProxy;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class GraphDatabaseShellServer
extends AbstractAppServer {
    private final GraphDatabaseAPI graphDb;
    private boolean graphDbCreatedHere;
    protected final Map<Serializable, Transaction> transactions = new ConcurrentHashMap<Serializable, Transaction>();

    public GraphDatabaseShellServer(String path, boolean readOnly, String configFileOrNull) throws RemoteException {
        this(GraphDatabaseShellServer.instantiateGraphDb(path, readOnly, configFileOrNull), readOnly);
        this.graphDbCreatedHere = true;
    }

    public GraphDatabaseShellServer(GraphDatabaseAPI graphDb) throws RemoteException {
        this(graphDb, false);
    }

    public GraphDatabaseShellServer(GraphDatabaseAPI graphDb, boolean readOnly) throws RemoteException {
        this.graphDb = readOnly ? new ReadOnlyGraphDatabaseProxy(graphDb) : graphDb;
        this.bashInterpreter.addReplacer("W", new WorkingDirReplacer());
        this.graphDbCreatedHere = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response interpretLine(Serializable clientId, String line, Output out) throws ShellException {
        this.restoreTransaction(clientId);
        try {
            Response response = super.interpretLine(clientId, line, out);
            return response;
        }
        finally {
            this.saveTransaction(clientId);
        }
    }

    private void saveTransaction(Serializable clientId) throws ShellException {
        try {
            Transaction tx = this.getDb().getDependencyResolver().resolveDependency(TransactionManager.class).suspend();
            if (tx == null) {
                this.transactions.remove(clientId);
            } else {
                this.transactions.put(clientId, tx);
            }
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private void restoreTransaction(Serializable clientId) throws ShellException {
        Transaction tx = this.transactions.get(clientId);
        if (tx != null) {
            try {
                this.getDb().getDependencyResolver().resolveDependency(TransactionManager.class).resume(tx);
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
        }
    }

    @Override
    protected void initialPopulateSession(Session session) throws ShellException {
        session.set("TITLE_KEYS", ".*name.*,.*title.*");
        session.set("TITLE_MAX_LENGTH", "40");
    }

    @Override
    protected String getPrompt(Session session) throws ShellException {
        try (org.neo4j.graphdb.Transaction transaction = this.getDb().beginTx();){
            Object rawCustomPrompt = session.get("PS1");
            String customPrompt = rawCustomPrompt != null ? rawCustomPrompt.toString() : this.getDefaultPrompt();
            String output = this.bashInterpreter.interpret(customPrompt, this, session);
            transaction.success();
            String string = output;
            return string;
        }
    }

    private static GraphDatabaseAPI instantiateGraphDb(String path, boolean readOnly, String configFileOrNull) {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).setConfig(GraphDatabaseSettings.read_only, Boolean.toString(readOnly));
        if (configFileOrNull != null) {
            builder.loadPropertiesFromFile(configFileOrNull);
        }
        return (GraphDatabaseAPI)builder.newGraphDatabase();
    }

    @Override
    protected String getDefaultPrompt() {
        String name = "neo4j-sh";
        if (this.graphDb instanceof ReadOnlyGraphDatabaseProxy) {
            name = name + "[readonly]";
        }
        name = name + " \\W$ ";
        return name;
    }

    @Override
    protected String getWelcomeMessage() {
        return "Welcome to the Neo4j Shell! Enter 'help' for a list of commands";
    }

    public GraphDatabaseAPI getDb() {
        return this.graphDb;
    }

    @Override
    public void shutdown() throws RemoteException {
        if (this.graphDbCreatedHere) {
            this.graphDb.shutdown();
        }
        super.shutdown();
    }

    @Override
    public Welcome welcome(Map<String, Serializable> initialSession) throws RemoteException, ShellException {
        try (org.neo4j.graphdb.Transaction transaction = this.graphDb.beginTx();){
            Welcome welcome = super.welcome(initialSession);
            transaction.success();
            Welcome welcome2 = welcome;
            return welcome2;
        }
    }

    public static class WorkingDirReplacer
    implements BashVariableInterpreter.Replacer {
        @Override
        public String getReplacement(ShellServer server, Session session) throws ShellException {
            try {
                return TransactionProvidingApp.getDisplayName((GraphDatabaseShellServer)server, session, TransactionProvidingApp.getCurrent((GraphDatabaseShellServer)server, session), false);
            }
            catch (ShellException e) {
                return TransactionProvidingApp.getDisplayNameForNonExistent();
            }
        }
    }
}

