/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.shell.Console;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.Welcome;
import org.neo4j.shell.impl.JLineConsole;
import org.neo4j.shell.impl.StandardConsole;

public abstract class AbstractClient
implements ShellClient {
    public static final String WARN_UNTERMINATED_INPUT = "Warning: Exiting with unterminated multi-line input.";
    private static final Set<String> EXIT_COMMANDS = new HashSet<String>(Arrays.asList("exit", "quit", null));
    private Console console;
    private long timeConnection;
    private volatile boolean end;
    private final Collection<String> multiLine = new ArrayList<String>();
    private Serializable id;
    private String prompt;
    private final Map<String, Serializable> initialSession;

    public AbstractClient(Map<String, Serializable> initialSession) {
        this.initialSession = initialSession;
    }

    @Override
    public void grabPrompt() {
        this.init();
        while (!this.end) {
            try {
                this.evaluate(this.readLine(this.getPrompt()));
            }
            catch (Exception e) {
                if (this.shouldPrintStackTraces()) {
                    e.printStackTrace();
                    continue;
                }
                this.console.format(AbstractClient.getShortExceptionMessage(e) + "\n", new Object[0]);
            }
        }
        this.shutdown();
    }

    @Override
    public void evaluate(String line) throws ShellException {
        this.evaluate(line, this.getOutput());
    }

    @Override
    public void evaluate(String line, Output out) throws ShellException {
        if (EXIT_COMMANDS.contains(line)) {
            this.end();
            return;
        }
        boolean success = false;
        try {
            String expandedLine = this.fullLine(line);
            Response response = this.getServer().interpretLine(this.id, expandedLine, out);
            switch (response.getContinuation()) {
                case INPUT_COMPLETE: {
                    this.endMultiLine();
                    break;
                }
                case INPUT_INCOMPLETE: {
                    this.multiLine.add(line);
                    break;
                }
                case EXIT: {
                    this.getServer().leave(this.id);
                    this.end();
                }
            }
            this.prompt = response.getPrompt();
            success = true;
        }
        catch (RemoteException e) {
            throw ShellException.wrapCause(e);
        }
        finally {
            if (!success) {
                this.endMultiLine();
            }
        }
    }

    private void endMultiLine() {
        this.multiLine.clear();
    }

    private String fullLine(String line) {
        if (this.multiLine.isEmpty()) {
            return line;
        }
        StringBuilder result = new StringBuilder();
        for (String oneLine : this.multiLine) {
            result.append(result.length() > 0 ? "\n" : "").append(oneLine);
        }
        return result.append("\n" + line).toString();
    }

    @Override
    public void end() {
        this.end = true;
    }

    protected static String getShortExceptionMessage(Exception e) {
        return e.getMessage();
    }

    @Override
    public String getPrompt() {
        if (!this.multiLine.isEmpty()) {
            return "> ";
        }
        return this.prompt;
    }

    public boolean shouldPrintStackTraces() {
        try {
            String stringValue = (String)((Object)this.getServer().interpretVariable(this.id, "STACKTRACES"));
            return Boolean.parseBoolean(stringValue);
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void init() {
        try {
            this.getServer();
            this.console = JLineConsole.newConsoleOrNullIfNotFound(this);
            if (this.console == null) {
                System.out.println("Want bash-like features? throw in jLine (http://jline.sourceforge.net) on the classpath");
                this.console = new StandardConsole();
            }
            this.getOutput().println();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sayHi(ShellServer server) throws RemoteException, ShellException {
        Welcome welcome = server.welcome(this.initialSession);
        this.id = welcome.getId();
        this.prompt = welcome.getPrompt();
        if (!welcome.getMessage().isEmpty()) {
            this.getOutput().println((Serializable)((Object)welcome.getMessage()));
        }
    }

    protected String readLine(String prompt) {
        return this.console.readLine(prompt);
    }

    protected void updateTimeForMostRecentConnection() {
        this.timeConnection = System.currentTimeMillis();
    }

    @Override
    public long timeForMostRecentConnection() {
        return this.timeConnection;
    }

    @Override
    public void shutdown() {
        if (!this.multiLine.isEmpty()) {
            try {
                this.getOutput().println((Serializable)((Object)WARN_UNTERMINATED_INPUT));
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    protected void tryUnexport(Remote remote) {
        try {
            UnicastRemoteObject.unexportObject(remote, true);
        }
        catch (NoSuchObjectException e) {
            System.out.println("Couldn't unexport: " + remote);
        }
    }

    @Override
    public void setSessionVariable(String key, Serializable value) throws ShellException {
        try {
            this.getServer().setSessionVariable(this.id, key, value);
        }
        catch (RemoteException e) {
            throw ShellException.wrapCause(e);
        }
    }
}

