/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.demo;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class MinMax {
    MinMax() {
    }

    public static void main(String[] args) throws IOException {
        long start = Util.getTime();
        long end = start + 90000L;
        String rrdFile = Util.getRrd4jDemoPath("minmax.rrd");
        String pngFile = Util.getRrd4jDemoPath("minmax.png");
        RrdDef rrdDef = new RrdDef(rrdFile, start - 1L, 300L);
        rrdDef.addDatasource("a", DsType.GAUGE, 600L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 300);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 12, 300);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 12, 300);
        RrdDb rrdDb = new RrdDb(rrdDef);
        for (long t = start; t < end; t += 300L) {
            Sample sample = rrdDb.createSample(t);
            sample.setValue("a", Math.sin((double)t / 3000.0) * 50.0 + 50.0);
            sample.update();
        }
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setFilename(pngFile);
        gDef.setWidth(450);
        gDef.setHeight(250);
        gDef.setImageFormat("png");
        gDef.setTimeSpan(start, start + 86400L);
        gDef.setTitle("RRDTool's MINMAX.pl demo");
        gDef.datasource("a", rrdFile, "a", ConsolFun.AVERAGE);
        gDef.datasource("b", rrdFile, "a", ConsolFun.MIN);
        gDef.datasource("c", rrdFile, "a", ConsolFun.MAX);
        gDef.area("a", Color.decode("0xb6e4"), "real");
        gDef.line("b", (Paint)Color.decode("0x22e9"), "min");
        gDef.line("c", (Paint)Color.decode("0xee22"), "max");
        new RrdGraph(gDef);
    }
}

