/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    public static final boolean EXECUTE_ONFILLABLE = true;
    private final List<Connection.Listener> listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final AtomicReference<State> _state = new AtomicReference<State>(State.IDLE);
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private final boolean _executeOnfillable;
    private int _inputBufferSize = 2048;

    protected AbstractConnection(EndPoint endp, Executor executor) {
        this(endp, executor, true);
    }

    protected AbstractConnection(EndPoint endp, Executor executor, boolean executeOnfillable) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endp;
        this._executor = executor;
        this._readCallback = new ReadCallback();
        this._executeOnfillable = executeOnfillable;
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this.listeners.add(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this._inputBufferSize = inputBufferSize;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fillInterested() {
        LOG.debug("fillInterested {}", new Object[]{this});
        while (true) {
            switch (this._state.get()) {
                case IDLE: {
                    if (!this._state.compareAndSet(State.IDLE, State.INTERESTED)) break;
                    this.getEndPoint().fillInterested(this._readCallback);
                    return;
                }
                case FILLING: {
                    if (!this._state.compareAndSet(State.FILLING, State.FILLING_INTERESTED)) break;
                    return;
                }
                case FILLING_BLOCKED: {
                    if (!this._state.compareAndSet(State.FILLING_BLOCKED, State.FILLING_BLOCKED_INTERESTED)) break;
                    return;
                }
                case BLOCKED: {
                    if (!this._state.compareAndSet(State.BLOCKED, State.BLOCKED_INTERESTED)) break;
                    return;
                }
                case FILLING_BLOCKED_INTERESTED: 
                case FILLING_INTERESTED: 
                case BLOCKED_INTERESTED: 
                case INTERESTED: {
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unblock() {
        LOG.debug("unblock {}", new Object[]{this});
        while (true) {
            switch (this._state.get()) {
                case FILLING_BLOCKED: {
                    if (!this._state.compareAndSet(State.FILLING_BLOCKED, State.FILLING)) break;
                    return;
                }
                case FILLING_BLOCKED_INTERESTED: {
                    if (!this._state.compareAndSet(State.FILLING_BLOCKED_INTERESTED, State.FILLING_INTERESTED)) break;
                    return;
                }
                case BLOCKED_INTERESTED: {
                    if (!this._state.compareAndSet(State.BLOCKED_INTERESTED, State.INTERESTED)) break;
                    this.getEndPoint().fillInterested(this._readCallback);
                    return;
                }
                case BLOCKED: {
                    if (!this._state.compareAndSet(State.BLOCKED, State.IDLE)) break;
                    return;
                }
                case IDLE: 
                case FILLING: 
                case FILLING_INTERESTED: 
                case INTERESTED: {
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void block(final BlockingCallback callback) {
        LOG.debug("block {}", new Object[]{this});
        Callback blocked = new Callback(){

            public void succeeded() {
                AbstractConnection.this.unblock();
                callback.succeeded();
            }

            public void failed(Throwable x) {
                AbstractConnection.this.unblock();
                callback.failed(x);
            }
        };
        while (true) {
            switch (this._state.get()) {
                case IDLE: {
                    if (!this._state.compareAndSet(State.IDLE, State.BLOCKED)) break;
                    this.getEndPoint().fillInterested(blocked);
                    return;
                }
                case FILLING: {
                    if (!this._state.compareAndSet(State.FILLING, State.FILLING_BLOCKED)) break;
                    this.getEndPoint().fillInterested(blocked);
                    return;
                }
                case FILLING_INTERESTED: {
                    if (!this._state.compareAndSet(State.FILLING_INTERESTED, State.FILLING_BLOCKED_INTERESTED)) break;
                    this.getEndPoint().fillInterested(blocked);
                    return;
                }
                case FILLING_BLOCKED: 
                case BLOCKED: 
                case FILLING_BLOCKED_INTERESTED: 
                case BLOCKED_INTERESTED: {
                    throw new IllegalStateException("Already Blocked");
                }
                case INTERESTED: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable cause) {
        LOG.debug("{} onFillInterestedFailed {}", new Object[]{this, cause});
        if (this._endPoint.isOpen()) {
            boolean close = true;
            if (cause instanceof TimeoutException) {
                close = this.onReadTimeout();
            }
            if (close) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                }
            }
        }
    }

    protected boolean onReadTimeout() {
        return true;
    }

    @Override
    public void onOpen() {
        LOG.debug("onOpen {}", new Object[]{this});
        for (Connection.Listener listener : this.listeners) {
            listener.onOpened(this);
        }
    }

    @Override
    public void onClose() {
        LOG.debug("onClose {}", new Object[]{this});
        for (Connection.Listener listener : this.listeners) {
            listener.onClosed(this);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public int getMessagesIn() {
        return -1;
    }

    @Override
    public int getMessagesOut() {
        return -1;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public String toString() {
        return String.format("%s@%x{%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state.get()});
    }

    private class ReadCallback
    implements Callback,
    Runnable {
        private ReadCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (!AbstractConnection.this._state.compareAndSet(State.INTERESTED, State.FILLING)) {
                LOG.warn((Throwable)new IllegalStateException());
                return;
            }
            try {
                AbstractConnection.this.onFillable();
            }
            catch (Throwable throwable) {
                while (true) {
                    switch ((State)((Object)AbstractConnection.this._state.get())) {
                        case IDLE: 
                        case BLOCKED: 
                        case BLOCKED_INTERESTED: 
                        case INTERESTED: {
                            LOG.warn((Throwable)new IllegalStateException());
                            return;
                        }
                        case FILLING: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING, State.IDLE)) break;
                            throw throwable;
                        }
                        case FILLING_BLOCKED: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING_BLOCKED, State.BLOCKED)) break;
                            throw throwable;
                        }
                        case FILLING_BLOCKED_INTERESTED: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING_BLOCKED_INTERESTED, State.BLOCKED_INTERESTED)) break;
                            throw throwable;
                        }
                        case FILLING_INTERESTED: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING_INTERESTED, State.INTERESTED)) break;
                            AbstractConnection.this.getEndPoint().fillInterested(AbstractConnection.this._readCallback);
                            throw throwable;
                        }
                    }
                }
            }
            while (true) {
                switch ((State)((Object)AbstractConnection.this._state.get())) {
                    case IDLE: 
                    case BLOCKED: 
                    case BLOCKED_INTERESTED: 
                    case INTERESTED: {
                        LOG.warn((Throwable)new IllegalStateException());
                        return;
                    }
                    case FILLING: {
                        if (!AbstractConnection.this._state.compareAndSet(State.FILLING, State.IDLE)) break;
                        return;
                    }
                    case FILLING_BLOCKED: {
                        if (!AbstractConnection.this._state.compareAndSet(State.FILLING_BLOCKED, State.BLOCKED)) break;
                        return;
                    }
                    case FILLING_BLOCKED_INTERESTED: {
                        if (!AbstractConnection.this._state.compareAndSet(State.FILLING_BLOCKED_INTERESTED, State.BLOCKED_INTERESTED)) break;
                        return;
                    }
                    case FILLING_INTERESTED: {
                        if (!AbstractConnection.this._state.compareAndSet(State.FILLING_INTERESTED, State.INTERESTED)) break;
                        AbstractConnection.this.getEndPoint().fillInterested(AbstractConnection.this._readCallback);
                        return;
                    }
                }
            }
        }

        public void succeeded() {
            if (AbstractConnection.this._executeOnfillable) {
                AbstractConnection.this._executor.execute(this);
            } else {
                this.run();
            }
        }

        public void failed(Throwable x) {
            AbstractConnection.this.onFillInterestedFailed(x);
        }

        public String toString() {
            return String.format("AC.ExReadCB@%x", AbstractConnection.this.hashCode());
        }
    }

    private static enum State {
        IDLE,
        INTERESTED,
        FILLING,
        FILLING_INTERESTED,
        FILLING_BLOCKED,
        BLOCKED,
        FILLING_BLOCKED_INTERESTED,
        BLOCKED_INTERESTED;

    }
}

