/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.p2;

import java.util.Collection;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.spi.connector.ArtifactUpload;
import org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.spi.connector.MetadataUpload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.MetadataTransferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2RepositoryConnector
implements RepositoryConnector {
    private final RemoteRepository repository;

    public P2RepositoryConnector(RemoteRepository repository) {
        this.repository = repository;
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        if (artifactDownloads != null) {
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                artifactDownload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactDownload.getArtifact(), this.repository));
            }
        }
        if (metadataDownloads != null) {
            for (MetadataDownload metadataDownload : metadataDownloads) {
                metadataDownload.setException((MetadataTransferException)new MetadataNotFoundException(metadataDownload.getMetadata(), this.repository));
            }
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        if (artifactUploads != null) {
            for (ArtifactUpload artifactUpload : artifactUploads) {
                artifactUpload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactUpload.getArtifact(), this.repository));
            }
        }
        if (metadataUploads != null) {
            for (MetadataUpload metadataUpload : metadataUploads) {
                metadataUpload.setException((MetadataTransferException)new MetadataNotFoundException(metadataUpload.getMetadata(), this.repository));
            }
        }
    }

    public void close() {
    }
}

