/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools.targetplatform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.maven.MavenDependencyCollector;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.core.osgitools.targetplatform.DefaultDependencyArtifacts;
import org.eclipse.tycho.core.osgitools.targetplatform.EclipseInstallationLayout;
import org.eclipse.tycho.model.Feature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyResolver.class, hint="local", instantiationStrategy="per-lookup")
public class LocalDependencyResolver
extends AbstractLogEnabled
implements DependencyResolver {
    public static final String ROLE_HINT = "local";
    @Requirement
    private EclipseInstallationLayout layout;
    @Requirement
    private BundleReader manifestReader;
    @Requirement
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Requirement
    private BundleReader bundleReader;

    private boolean isSubdir(File parent, File child) {
        return child.getAbsolutePath().startsWith(parent.getAbsolutePath());
    }

    private void addProjects(MavenSession session, DefaultDependencyArtifacts platform) {
        File parentDir = null;
        for (MavenProject project : session.getProjects()) {
            ReactorProject projectProxy = DefaultReactorProject.adapt(project);
            TychoProject dr = this.projectTypes.get(project.getPackaging());
            if (dr == null) continue;
            ArtifactKey key = dr.getArtifactKey(projectProxy);
            platform.removeAll(key.getType(), key.getId());
            platform.addReactorArtifact(key, projectProxy, null, null);
            if (parentDir != null && !this.isSubdir(project.getBasedir(), parentDir)) continue;
            parentDir = project.getBasedir();
        }
    }

    @Override
    public void setupProjects(MavenSession session, MavenProject project, ReactorProject reactorProject) {
    }

    @Override
    public TargetPlatform computePreliminaryTargetPlatform(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        return null;
    }

    @Override
    public DependencyArtifacts resolveDependencies(MavenSession session, MavenProject project, TargetPlatform resolutionContext, List<ReactorProject> reactorProjects, DependencyResolverConfiguration resolverConfiguration) {
        DefaultDependencyArtifacts platform = new DefaultDependencyArtifacts(DefaultReactorProject.adapt(project));
        for (File site : this.layout.getSites()) {
            for (File plugin : this.layout.getPlugins(site)) {
                ArtifactKey artifactKey = this.getArtifactKey(session, plugin);
                if (artifactKey == null) continue;
                platform.addArtifactFile(artifactKey, plugin, null);
            }
            for (File feature : this.layout.getFeatures(site)) {
                Feature desc = Feature.loadFeature((File)feature);
                DefaultArtifactKey key = new DefaultArtifactKey("eclipse-feature", desc.getId(), desc.getVersion());
                platform.addArtifactFile((ArtifactKey)key, feature, null);
            }
        }
        this.addProjects(session, platform);
        this.addDependencies(session, project, platform);
        if (platform.isEmpty()) {
            this.getLogger().warn("Could not find any bundles or features in " + this.layout.getLocation());
        }
        return platform;
    }

    private void addDependencies(MavenSession session, MavenProject project, DefaultDependencyArtifacts platform) {
        TargetPlatformConfiguration configuration = (TargetPlatformConfiguration)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        if (configuration != null && "consider".equals(configuration.getPomDependencies())) {
            Collection artifacts;
            String key;
            HashMap<String, MavenProject> projectIds = new HashMap<String, MavenProject>(session.getProjects().size() * 2);
            for (MavenProject p : session.getProjects()) {
                key = ArtifactUtils.key((String)p.getGroupId(), (String)p.getArtifactId(), (String)p.getVersion());
                projectIds.put(key, p);
            }
            for (Dependency dependency : project.getDependencies()) {
                MavenProject dependent;
                ArtifactKey artifactKey;
                if (!"compile".equals(dependency.getScope()) || !projectIds.containsKey(key = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion())) || (artifactKey = this.getArtifactKey(session, dependent = (MavenProject)projectIds.get(key))) == null) continue;
                platform.removeAll(artifactKey.getType(), artifactKey.getId());
                ReactorProject projectProxy = DefaultReactorProject.adapt(dependent);
                platform.addReactorArtifact(artifactKey, projectProxy, null, null);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Add Maven project " + artifactKey);
            }
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("compile");
            try {
                artifacts = this.projectDependenciesResolver.resolve(project, scopes, session);
            }
            catch (MultipleArtifactsNotFoundException e) {
                HashSet missing = new HashSet(e.getMissingArtifacts());
                Iterator it = missing.iterator();
                while (it.hasNext()) {
                    Artifact a = (Artifact)it.next();
                    String key2 = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getBaseVersion());
                    if (!projectIds.containsKey(key2)) continue;
                    it.remove();
                }
                if (!missing.isEmpty()) {
                    throw new RuntimeException("Could not resolve project dependencies", e);
                }
                artifacts = e.getResolvedArtifacts();
                artifacts.removeAll(e.getMissingArtifacts());
            }
            catch (AbstractArtifactResolutionException e) {
                throw new RuntimeException("Could not resolve project dependencies", e);
            }
            for (Artifact artifact : artifacts) {
                File plugin;
                ArtifactKey artifactKey;
                String key3 = ArtifactUtils.key((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion());
                if (projectIds.containsKey(key3) || (artifactKey = this.getArtifactKey(session, plugin = artifact.getFile())) == null) continue;
                platform.addArtifactFile(artifactKey, plugin, null);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Add Maven artifact " + artifactKey);
            }
        }
    }

    public ArtifactKey getArtifactKey(MavenSession session, MavenProject project) {
        OsgiManifest mf;
        try {
            mf = this.manifestReader.loadManifest(project.getBasedir());
        }
        catch (OsgiManifestParserException e) {
            return null;
        }
        return mf.toArtifactKey();
    }

    public ArtifactKey getArtifactKey(MavenSession session, File plugin) {
        OsgiManifest mf = this.manifestReader.loadManifest(plugin);
        ArtifactKey key = mf.toArtifactKey();
        return key;
    }

    public void setLocation(File location) throws IOException {
        this.layout.setLocation(location.getAbsoluteFile());
    }

    @Override
    public void injectDependenciesIntoMavenModel(MavenProject project, AbstractTychoProject projectType, DependencyArtifacts targetPlatform, Logger logger) {
        projectType.checkForMissingDependencies(project);
        MavenDependencyCollector dependencyCollector = new MavenDependencyCollector(project, this.bundleReader, logger);
        projectType.getDependencyWalker(project).walk(dependencyCollector);
    }
}

