/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.InputStream;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.UnknownEnvironmentException;
import org.eclipse.tycho.core.osgitools.InvalidOSGiManifestException;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiManifest {
    private static final StandardExecutionEnvironment[] EMPTY_EXEC_ENV = new StandardExecutionEnvironment[0];
    private String location;
    private Headers<String, String> headers;
    private String bundleSymbolicName;
    private String bundleVersion;
    private String[] bundleClassPath;
    private StandardExecutionEnvironment[] executionEnvironments;
    private boolean isDirectoryShape;

    private OsgiManifest(InputStream stream, String location) throws OsgiManifestParserException {
        this.location = location;
        try {
            this.headers = Headers.parseManifest((InputStream)stream);
            BundleDescription bundleDescription = StateObjectFactoryImpl.defaultFactory.createBundleDescription(null, this.headers, location, 0L);
            this.bundleSymbolicName = bundleDescription.getSymbolicName();
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(location, e);
        }
        this.bundleVersion = this.parseBundleVersion();
        this.bundleClassPath = this.parseBundleClasspath();
        this.isDirectoryShape = this.parseDirectoryShape();
        this.executionEnvironments = this.parseExecutionEnvironments();
    }

    private StandardExecutionEnvironment[] parseExecutionEnvironments() {
        ManifestElement[] brees = this.getManifestElements("Bundle-RequiredExecutionEnvironment");
        if (brees == null || brees.length == 0) {
            return EMPTY_EXEC_ENV;
        }
        StandardExecutionEnvironment[] envs = new StandardExecutionEnvironment[brees.length];
        try {
            for (int i = 0; i < brees.length; ++i) {
                envs[i] = ExecutionEnvironmentUtils.getExecutionEnvironment(brees[i].getValue());
            }
        }
        catch (UnknownEnvironmentException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
        return envs;
    }

    private String parseBundleVersion() {
        String versionString = this.parseMandatoryFirstValue("Bundle-Version");
        try {
            return Version.parseVersion((String)versionString).toString();
        }
        catch (NumberFormatException e) {
            throw new InvalidOSGiManifestException(this.location, "Bundle-Version '" + versionString + "' is invalid");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOSGiManifestException(this.location, e);
        }
    }

    private String parseMandatoryFirstValue(String headerKey) throws InvalidOSGiManifestException {
        String value = (String)this.headers.get((Object)headerKey);
        if (value == null) {
            throw new InvalidOSGiManifestException(this.location, "MANIFEST header '" + headerKey + "' not found");
        }
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)headerKey, (String)value);
        }
        catch (BundleException e) {
            throw new InvalidOSGiManifestException(this.location, e);
        }
        if (elements == null || elements.length == 0) {
            throw new InvalidOSGiManifestException(this.location, "value for MANIFEST header '" + headerKey + "' is empty");
        }
        return elements[0].getValue();
    }

    private boolean parseDirectoryShape() {
        ManifestElement[] bundleShapeElements = this.parseHeader("Eclipse-BundleShape");
        return bundleShapeElements != null && bundleShapeElements.length > 0 && "dir".equals(bundleShapeElements[0].getValue());
    }

    public Headers<String, String> getHeaders() {
        return this.headers;
    }

    public String getValue(String key) {
        return (String)this.headers.get((Object)key);
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public ArtifactKey toArtifactKey() {
        return new DefaultArtifactKey("eclipse-plugin", this.getBundleSymbolicName(), this.getBundleVersion());
    }

    public String[] getBundleClasspath() {
        return this.bundleClassPath;
    }

    public StandardExecutionEnvironment[] getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public boolean isDirectoryShape() {
        return this.isDirectoryShape;
    }

    static OsgiManifest parse(InputStream stream, String location) throws OsgiManifestParserException {
        return new OsgiManifest(stream, location);
    }

    private ManifestElement[] parseHeader(String key) {
        String value = (String)this.headers.get((Object)key);
        if (value == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)key, (String)value);
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
    }

    public ManifestElement[] getManifestElements(String key) throws OsgiManifestParserException {
        try {
            return ManifestElement.parseHeader((String)key, (String)((String)this.headers.get((Object)key)));
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
    }

    private String[] parseBundleClasspath() {
        ManifestElement[] classpathEntries;
        String[] result = new String[]{"."};
        String classPathValue = this.getValue("Bundle-ClassPath");
        if (classPathValue != null && (classpathEntries = this.getManifestElements("Bundle-ClassPath")) != null) {
            result = new String[classpathEntries.length];
            for (int i = 0; i < classpathEntries.length; ++i) {
                result[i] = classpathEntries[i].getValue();
            }
        }
        return result;
    }
}

