/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.osgitools.AbstractArtifactBasedProject;
import org.eclipse.tycho.core.osgitools.AbstractArtifactDependencyWalker;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.model.ProductConfiguration;

@Component(role=TychoProject.class, hint="eclipse-application")
public class EclipseApplicationProject
extends AbstractArtifactBasedProject {
    protected ArtifactDependencyWalker newDependencyWalker(MavenProject project, TargetEnvironment environment) {
        final ProductConfiguration product = this.loadProduct(DefaultReactorProject.adapt(project));
        return new AbstractArtifactDependencyWalker(this.getDependencyArtifacts(project, environment), this.getEnvironments(project, environment)){

            public void walk(ArtifactDependencyVisitor visitor) {
                this.traverseProduct(product, visitor);
            }
        };
    }

    protected ProductConfiguration loadProduct(ReactorProject project) {
        File file = new File(project.getBasedir(), project.getArtifactId() + ".product");
        try {
            return ProductConfiguration.read((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read product configuration file " + file.getAbsolutePath(), e);
        }
    }

    public ArtifactKey getArtifactKey(ReactorProject project) {
        ProductConfiguration product = this.loadProduct(project);
        String id = product.getId() != null ? product.getId() : project.getArtifactId();
        String version = product.getVersion() != null ? product.getVersion() : this.getOsgiVersion(project);
        return new DefaultArtifactKey("eclipse-application", id, version);
    }
}

