/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.OsgiManifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependencyComputer.class)
public class DependencyComputer {
    @Requirement
    private BundleReader manifestReader;

    public List<DependencyEntry> computeDependencies(StateHelper helper, BundleDescription desc) {
        ArrayList<DependencyEntry> entries = new ArrayList<DependencyEntry>();
        if (desc == null) {
            return entries;
        }
        Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map = this.retrieveVisiblePackagesFromState(helper, desc);
        HashSet<BundleDescription> added = new HashSet<BundleDescription>();
        added.add(desc);
        HostSpecification host = desc.getHost();
        if (host != null) {
            this.addHostPlugin(host, added, map, entries);
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        for (int i = 0; i < required.length; ++i) {
            this.addDependency((BundleDescription)required[i].getSupplier(), added, map, entries);
        }
        TreeMap<String, BundleDescription> sortedMap = new TreeMap<String, BundleDescription>();
        for (BundleDescription bundle : map.keySet()) {
            sortedMap.put(bundle.toString(), bundle);
        }
        for (BundleDescription bundle : sortedMap.values()) {
            this.addDependencyViaImportPackage(bundle, added, map, entries);
        }
        return entries;
    }

    private Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> retrieveVisiblePackagesFromState(StateHelper helper, BundleDescription desc) {
        HashMap<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> visiblePackages = new HashMap<BundleDescription, ArrayList<ClasspathEntry.AccessRule>>();
        this.addVisiblePackagesFromState(helper, desc, visiblePackages);
        if (desc.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> visiblePackages) {
        if (desc == null) {
            return;
        }
        ExportPackageDescription[] exports = helper.getVisiblePackages(desc, 1);
        for (int i = 0; i < exports.length; ++i) {
            ClasspathEntry.AccessRule rule;
            BundleDescription exporter = exports[i].getExporter();
            if (exporter == null) continue;
            ArrayList<Object> list = visiblePackages.get(exporter);
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(rule = this.getRule(helper, desc, exports[i]))) {
                list.add(rule);
            }
            visiblePackages.put(exporter, list);
        }
    }

    private ClasspathEntry.AccessRule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        boolean discouraged = helper.getAccessCode(desc, export) == 2;
        String name = export.getName();
        String path = name.equals(".") ? "*" : name.replaceAll("\\.", "/") + "/*";
        return new DefaultClasspathEntry.DefaultAccessRule(path, discouraged);
    }

    protected void addDependencyViaImportPackage(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, ArrayList<DependencyEntry> entries) {
        if (desc == null || !added.add(desc)) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments = desc.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                if (!fragments[i].isResolved()) continue;
                this.addDependencyViaImportPackage(fragments[i], added, map, entries);
            }
        }
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, ArrayList<DependencyEntry> entries) {
        this.addDependency(desc, added, map, entries, true);
    }

    private void addDependency(BundleDescription desc, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, ArrayList<DependencyEntry> entries, boolean useInclusion) {
        int i;
        if (desc == null || !added.add(desc)) {
            return;
        }
        BundleDescription[] fragments = this.hasExtensibleAPI(desc) ? desc.getFragments() : new BundleDescription[]{};
        for (i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved() || !this.isPatchFragment(fragments[i])) continue;
            this.addDependency(fragments[i], added, map, entries, useInclusion);
        }
        this.addPlugin(desc, useInclusion, map, entries);
        for (i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved() || this.isPatchFragment(fragments[i])) continue;
            this.addDependency(fragments[i], added, map, entries, useInclusion);
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        for (int i2 = 0; i2 < required.length; ++i2) {
            this.addDependency((BundleDescription)required[i2].getSupplier(), added, map, entries, useInclusion);
        }
    }

    private boolean isPatchFragment(BundleDescription bundleDescription) {
        return false;
    }

    private boolean addPlugin(BundleDescription desc, boolean useInclusions, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, ArrayList<DependencyEntry> entries) {
        List<ClasspathEntry.AccessRule> rules = useInclusions ? this.getInclusions(map, desc) : null;
        DependencyEntry entry = new DependencyEntry(desc, rules);
        if (!entries.contains(entry)) {
            entries.add(entry);
        }
        return true;
    }

    private List<ClasspathEntry.AccessRule> getInclusions(Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, BundleDescription desc) {
        ArrayList<Object> rules = desc.getHost() != null ? map.get((BundleDescription)desc.getHost().getSupplier()) : map.get(desc);
        return rules != null ? rules : new ArrayList();
    }

    private void addHostPlugin(HostSpecification hostSpec, HashSet<BundleDescription> added, Map<BundleDescription, ArrayList<ClasspathEntry.AccessRule>> map, ArrayList<DependencyEntry> entries) {
        BundleDescription host;
        BaseDescription desc = hostSpec.getSupplier();
        if (desc instanceof BundleDescription && added.add(host = (BundleDescription)desc) && this.addPlugin(host, false, map, entries)) {
            BundleSpecification[] required = host.getRequiredBundles();
            for (int i = 0; i < required.length; ++i) {
                this.addDependency((BundleDescription)required[i].getSupplier(), added, map, entries);
            }
            ImportPackageSpecification[] imports = host.getImportPackages();
            for (int i = 0; i < imports.length; ++i) {
                BaseDescription supplier = imports[i].getSupplier();
                if (!(supplier instanceof ExportPackageDescription)) continue;
                this.addDependencyViaImportPackage(((ExportPackageDescription)supplier).getExporter(), added, map, entries);
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        return true;
    }

    public List<ClasspathEntry.AccessRule> computeBootClasspathExtraAccessRules(StateHelper helper, BundleDescription desc) {
        ExportPackageDescription[] exports;
        ArrayList<ClasspathEntry.AccessRule> result = new ArrayList<ClasspathEntry.AccessRule>();
        for (ExportPackageDescription export : exports = helper.getVisiblePackages(desc)) {
            BundleDescription host = export.getExporter();
            BaseDescription fragment = ((ExportPackageDescriptionImpl)export).getFragmentDeclaration();
            if (host.getBundleId() != 0L || fragment == null || !this.isFrameworkExtension(fragment.getSupplier())) continue;
            result.add(this.getRule(helper, host, export));
        }
        return result;
    }

    private boolean isFrameworkExtension(BundleDescription bundle) {
        OsgiManifest mf = this.manifestReader.loadManifest(new File(bundle.getLocation()));
        ManifestElement[] elements = mf.getManifestElements("Fragment-Host");
        return elements.length == 1 && "framework".equals(elements[0].getDirective("extension"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DependencyEntry {
        public final BundleDescription desc;
        public final List<ClasspathEntry.AccessRule> rules;

        public DependencyEntry(BundleDescription desc, List<ClasspathEntry.AccessRule> rules) {
            this.desc = desc;
            this.rules = rules;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.rules == null ? 0 : this.rules.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyEntry other = (DependencyEntry)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            return !(this.rules == null ? other.rules != null : !this.rules.equals(other.rules));
        }
    }
}

